/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.access;

import com.hazelcast.hibernate.access.NonStrictReadWriteAccessDelegate;
import com.hazelcast.hibernate.region.HazelcastRegion;
import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;

public class ReadOnlyAccessDelegate<T extends HazelcastRegion>
extends NonStrictReadWriteAccessDelegate<T> {
    public ReadOnlyAccessDelegate(T hazelcastRegion, Properties props) {
        super(hazelcastRegion, props);
    }

    @Override
    public boolean afterInsert(Object key, Object value, Object version) throws CacheException {
        return this.cache.insert(key, value, version);
    }

    @Override
    public boolean afterUpdate(Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) throws CacheException {
        this.log.finest("Illegal attempt to update item cached as read-only [" + key + "]");
        throw new UnsupportedOperationException("Can't write to a readonly object");
    }

    @Override
    public boolean insert(Object key, Object value, Object version) throws CacheException {
        return false;
    }

    @Override
    public SoftLock lockItem(Object key, Object version) throws CacheException {
        return null;
    }

    @Override
    public SoftLock lockRegion() throws CacheException {
        return null;
    }

    @Override
    public void removeAll() throws CacheException {
        this.cache.clear();
    }

    @Override
    public void unlockItem(Object key, SoftLock lock) throws CacheException {
        this.evict(key);
    }

    @Override
    public void unlockRegion(SoftLock lock) throws CacheException {
        this.cache.clear();
    }

    @Override
    public boolean update(Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        this.log.finest("Illegal attempt to update item cached as read-only [" + key + "]");
        throw new UnsupportedOperationException("Can't update readonly object");
    }
}

