/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.querycache.subscriber;

import com.hazelcast.client.impl.querycache.subscriber.ListenerInfo;
import com.hazelcast.map.impl.ListenerAdapter;
import com.hazelcast.spi.EventFilter;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.UuidUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class QueryCacheToListenerMapper {
    private static final ConstructorFunction<String, Collection<ListenerInfo>> LISTENER_SET_CONSTRUCTOR = new ConstructorFunction<String, Collection<ListenerInfo>>(){

        public Collection<ListenerInfo> createNew(String arg) {
            return Collections.newSetFromMap(new ConcurrentHashMap());
        }
    };
    private final ConcurrentMap<String, Collection<ListenerInfo>> registrations = new ConcurrentHashMap<String, Collection<ListenerInfo>>();

    QueryCacheToListenerMapper() {
    }

    public String addListener(String cacheId, ListenerAdapter listenerAdapter, EventFilter filter) {
        Collection adapters = (Collection)ConcurrencyUtil.getOrPutIfAbsent(this.registrations, (Object)cacheId, LISTENER_SET_CONSTRUCTOR);
        String id = UuidUtil.newUnsecureUuidString();
        ListenerInfo info = new ListenerInfo(filter, listenerAdapter, id);
        adapters.add(info);
        return id;
    }

    public boolean removeListener(String cacheId, String listenerId) {
        Collection adapters = (Collection)ConcurrencyUtil.getOrPutIfAbsent(this.registrations, (Object)cacheId, LISTENER_SET_CONSTRUCTOR);
        Iterator iterator = adapters.iterator();
        while (iterator.hasNext()) {
            ListenerInfo listenerInfo = (ListenerInfo)iterator.next();
            String listenerInfoId = listenerInfo.getId();
            if (!listenerInfoId.equals(listenerId)) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public void removeAllListeners(String cacheId) {
        this.registrations.remove(cacheId);
    }

    public boolean hasListener(String cacheId) {
        Collection listenerInfos = (Collection)this.registrations.get(cacheId);
        return !CollectionUtil.isEmpty((Collection)listenerInfos);
    }

    public boolean hasAnyQueryCacheRegistered() {
        return !this.registrations.isEmpty();
    }

    Collection<ListenerInfo> getListenerInfos(String cacheId) {
        Collection infos = (Collection)this.registrations.get(cacheId);
        return CollectionUtil.isEmpty((Collection)infos) ? Collections.emptySet() : infos;
    }
}

