/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.querycache;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.querycache.subscriber.ClientInvokerWrapper;
import com.hazelcast.client.impl.querycache.subscriber.ClientQueryCacheConfigurator;
import com.hazelcast.client.impl.querycache.subscriber.ClientQueryCacheEventService;
import com.hazelcast.client.impl.querycache.subscriber.ClientQueryCacheScheduler;
import com.hazelcast.client.impl.querycache.subscriber.ClientSubscriberContext;
import com.hazelcast.core.Member;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.map.impl.querycache.InvokerWrapper;
import com.hazelcast.map.impl.querycache.QueryCacheConfigurator;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.querycache.QueryCacheEventService;
import com.hazelcast.map.impl.querycache.QueryCacheScheduler;
import com.hazelcast.map.impl.querycache.accumulator.Accumulator;
import com.hazelcast.map.impl.querycache.accumulator.AccumulatorInfo;
import com.hazelcast.map.impl.querycache.publisher.PublisherContext;
import com.hazelcast.map.impl.querycache.subscriber.InternalQueryCache;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheFactory;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberContext;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberRegistry;
import com.hazelcast.nio.Address;
import com.hazelcast.util.ContextMutexFactory;
import java.util.Collection;
import java.util.Map;

public class ClientQueryCacheContext
implements QueryCacheContext {
    private final HazelcastClientInstanceImpl client;
    private final InvokerWrapper invokerWrapper;
    private final QueryCacheScheduler queryCacheScheduler;
    private final QueryCacheEventService queryCacheEventService;
    private final QueryCacheConfigurator queryCacheConfigurator;
    private final ContextMutexFactory mutexFactory = new ContextMutexFactory();
    private SubscriberContext subscriberContext;

    public ClientQueryCacheContext(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.queryCacheEventService = new ClientQueryCacheEventService(client);
        this.queryCacheConfigurator = new ClientQueryCacheConfigurator(client.getClientConfig(), this.queryCacheEventService);
        this.queryCacheScheduler = new ClientQueryCacheScheduler(client.getClientExecutionService());
        this.invokerWrapper = new ClientInvokerWrapper(this, client);
        this.subscriberContext = new ClientSubscriberContext(this);
    }

    public SubscriberContext getSubscriberContext() {
        return this.subscriberContext;
    }

    public Object toObject(Object obj) {
        InternalSerializationService serializationService = this.client.getSerializationService();
        return serializationService.toObject(obj);
    }

    public void destroy() {
        throw new UnsupportedOperationException();
    }

    public InternalSerializationService getSerializationService() {
        return this.client.getSerializationService();
    }

    public Collection<Member> getMemberList() {
        return this.client.getClientClusterService().getMemberList();
    }

    public int getPartitionId(Object object) {
        return this.client.getClientPartitionService().getPartitionId(object);
    }

    public int getPartitionCount() {
        return this.client.getClientPartitionService().getPartitionCount();
    }

    public ContextMutexFactory getLifecycleMutexFactory() {
        return this.mutexFactory;
    }

    public InvokerWrapper getInvokerWrapper() {
        return this.invokerWrapper;
    }

    public QueryCacheEventService getQueryCacheEventService() {
        return this.queryCacheEventService;
    }

    public QueryCacheConfigurator getQueryCacheConfigurator() {
        return this.queryCacheConfigurator;
    }

    public QueryCacheScheduler getQueryCacheScheduler() {
        return this.queryCacheScheduler;
    }

    public void setSubscriberContext(SubscriberContext subscriberContext) {
        this.subscriberContext = subscriberContext;
    }

    public PublisherContext getPublisherContext() {
        throw new UnsupportedOperationException();
    }

    public Address getThisNodesAddress() {
        throw new UnsupportedOperationException();
    }

    public void recreateAllCaches() {
        QueryCacheFactory queryCacheFactory = this.subscriberContext.getQueryCacheFactory();
        Map registryMap = this.subscriberContext.getMapSubscriberRegistry().getAll();
        for (SubscriberRegistry subscriberRegistry : registryMap.values()) {
            Map accumulatorMap = subscriberRegistry.getAll();
            for (Accumulator accumulator : accumulatorMap.values()) {
                AccumulatorInfo info = accumulator.getInfo();
                String cacheId = info.getCacheId();
                InternalQueryCache queryCache = queryCacheFactory.getOrNull(cacheId);
                if (queryCache == null) continue;
                queryCache.recreate();
            }
        }
    }
}

