/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.HazelcastClientOfflineException;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.connection.ClientConnectionStrategy;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.nio.Address;
import java.util.concurrent.RejectedExecutionException;

public class DefaultClientConnectionStrategy
extends ClientConnectionStrategy {
    private volatile boolean disconnectedFromCluster;
    private boolean clientStartAsync;
    private ClientConnectionStrategyConfig.ReconnectMode reconnectMode;

    @Override
    public void start() {
        this.clientStartAsync = this.clientConnectionStrategyConfig.isAsyncStart();
        this.reconnectMode = this.clientConnectionStrategyConfig.getReconnectMode();
        if (this.clientStartAsync) {
            this.clientContext.getConnectionManager().connectToClusterAsync();
        } else {
            this.clientContext.getConnectionManager().connectToCluster();
        }
    }

    @Override
    public void beforeGetConnection(Address target) {
        if (this.isClusterAvailable()) {
            return;
        }
        if (this.clientStartAsync && !this.disconnectedFromCluster) {
            throw new HazelcastClientOfflineException("Client is connecting to cluster.");
        }
        if (this.reconnectMode == ClientConnectionStrategyConfig.ReconnectMode.ASYNC && this.disconnectedFromCluster) {
            throw new HazelcastClientOfflineException("Client is offline.");
        }
    }

    @Override
    public void beforeOpenConnection(Address target) {
        if (this.isClusterAvailable()) {
            return;
        }
        if (this.reconnectMode == ClientConnectionStrategyConfig.ReconnectMode.ASYNC && this.disconnectedFromCluster) {
            throw new HazelcastClientOfflineException("Client is offline");
        }
    }

    @Override
    public void beforeConnectToCluster(Address target) {
    }

    @Override
    public void onConnectToCluster() {
    }

    @Override
    public void onDisconnectFromCluster() {
        this.disconnectedFromCluster = true;
        if (this.reconnectMode == ClientConnectionStrategyConfig.ReconnectMode.OFF) {
            this.shutdownWithExternalThread();
            return;
        }
        if (this.clientContext.getLifecycleService().isRunning()) {
            try {
                this.clientContext.getConnectionManager().connectToClusterAsync();
            }
            catch (RejectedExecutionException r) {
                this.shutdownWithExternalThread();
            }
        }
    }

    private void shutdownWithExternalThread() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultClientConnectionStrategy.this.clientContext.getLifecycleService().shutdown();
                }
                catch (Exception exception) {
                    DefaultClientConnectionStrategy.this.logger.severe("Exception during client shutdown ", (Throwable)exception);
                }
            }
        }, this.clientContext.getName() + ".clientShutdown-").start();
    }

    @Override
    public void onConnect(ClientConnection connection) {
    }

    @Override
    public void onDisconnect(ClientConnection connection) {
    }

    @Override
    public void shutdown() {
    }

    private boolean isClusterAvailable() {
        return this.clientContext.getConnectionManager().getOwnerConnectionAddress() != null;
    }
}

