/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.test.archunit;

import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.lang.conditions.ArchConditions;
import java.util.Optional;

public class SerialVersionUidFieldCondition
extends ArchCondition<JavaClass> {
    private static final String FIELD_NAME = "serialVersionUID";

    SerialVersionUidFieldCondition() {
        super("have a valid serialVersionUID", new Object[0]);
    }

    public void check(JavaClass clazz, ConditionEvents events) {
        Optional field = clazz.tryGetField(FIELD_NAME);
        if (field.isPresent()) {
            ArchConditions.haveRawType((String)"long").and(ArchConditions.beFinal()).and(ArchConditions.beStatic()).check(field.get(), events);
        } else {
            events.add(SimpleConditionEvent.violated((Object)clazz, (String)("serialVersionUID field is missing in class " + clazz.getName())));
        }
    }

    static SerialVersionUidFieldCondition haveValidSerialVersionUid() {
        return new SerialVersionUidFieldCondition();
    }
}

