/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.test.archunit;

import com.tngtech.archunit.core.domain.AccessTarget;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaMember;
import com.tngtech.archunit.core.domain.JavaMethodCall;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.importer.ClassFileImporter;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CompletableFutureUsageCondition
extends ArchCondition<JavaClass> {
    private static final Set<String> COMPLETION_STAGE_METHODS = new ClassFileImporter().importClass(CompletionStage.class).getMethods().stream().map(JavaMember::getName).collect(Collectors.toSet());
    private static final Set<String> SYNC_AND_ASYNC_METHODS = CompletableFutureUsageCondition.collectSyncAndAsyncCounterpartMethods();

    CompletableFutureUsageCondition() {
        super("use only CompletableFuture async methods with explicit executor service", new Object[0]);
    }

    private static Set<String> collectSyncAndAsyncCounterpartMethods() {
        return COMPLETION_STAGE_METHODS.stream().flatMap(method -> {
            if (method.endsWith("Async")) {
                String syncMethod = method.substring(0, method.lastIndexOf("Async"));
                return COMPLETION_STAGE_METHODS.contains(syncMethod) ? Stream.of(syncMethod, method) : Stream.of(method);
            }
            return Stream.empty();
        }).collect(Collectors.toSet());
    }

    static ArchCondition<? super JavaClass> useExplicitExecutorServiceInCFAsyncMethods() {
        return new CompletableFutureUsageCondition();
    }

    public void check(JavaClass item, ConditionEvents events) {
        for (JavaMethodCall methodCalled : item.getMethodCallsFromSelf()) {
            List parameterTypes;
            String calledMethodName = ((AccessTarget.MethodCallTarget)methodCalled.getTarget()).getName();
            if (!this.isFromCompletionStage(methodCalled) || !this.isAsyncMethod(calledMethodName) || !this.isNotOverrideCompletableFutureMethod(methodCalled, item) || !this.withoutExecutorArgument(parameterTypes = ((AccessTarget.MethodCallTarget)methodCalled.getTarget()).getParameterTypes())) continue;
            String violatingMethodName = methodCalled.getOwner().getFullName();
            events.add(SimpleConditionEvent.violated((Object)item, (String)(violatingMethodName + ":" + methodCalled.getLineNumber() + " calls CompletableFuture." + calledMethodName)));
        }
    }

    private boolean isFromCompletionStage(JavaMethodCall methodCalled) {
        JavaClass calledClass = ((AccessTarget.MethodCallTarget)methodCalled.getTarget()).getOwner();
        return calledClass.isAssignableTo(CompletionStage.class);
    }

    private boolean isNotOverrideCompletableFutureMethod(JavaMethodCall methodCalled, JavaClass item) {
        return !item.isAssignableTo(CompletableFuture.class) || !COMPLETION_STAGE_METHODS.contains(methodCalled.getOwner().getName());
    }

    private boolean isAsyncMethod(String methodName) {
        return SYNC_AND_ASYNC_METHODS.contains(methodName);
    }

    private boolean withoutExecutorArgument(List<JavaType> parameterTypes) {
        return parameterTypes.isEmpty() || !parameterTypes.get(parameterTypes.size() - 1).toErasure().isEquivalentTo(Executor.class);
    }

    static {
        List<String> excludedSyncMethodsForJava8Compatibility = Arrays.asList("exceptionally");
        SYNC_AND_ASYNC_METHODS.removeAll(excludedSyncMethodsForJava8Compatibility);
    }
}

