/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.plan.node.io;

import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import com.hazelcast.sql.impl.plan.node.PlanNodeVisitor;
import com.hazelcast.sql.impl.plan.node.ZeroInputPlanNode;
import com.hazelcast.sql.impl.plan.node.io.EdgeAwarePlanNode;
import com.hazelcast.sql.impl.type.QueryDataType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class ReceiveSortMergePlanNode
extends ZeroInputPlanNode
implements EdgeAwarePlanNode,
IdentifiedDataSerializable {
    private int edgeId;
    private List<QueryDataType> fieldTypes;
    private int[] columnIndexes;
    private boolean[] ascs;
    private Expression fetch;
    private Expression offset;

    public ReceiveSortMergePlanNode() {
    }

    public ReceiveSortMergePlanNode(int id, int edgeId, List<QueryDataType> fieldTypes, int[] columnIndexes, boolean[] ascs, Expression fetch, Expression offset) {
        super(id);
        this.edgeId = edgeId;
        this.fieldTypes = fieldTypes;
        this.columnIndexes = columnIndexes;
        this.ascs = ascs;
        this.fetch = fetch;
        this.offset = offset;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public boolean[] getAscs() {
        return this.ascs;
    }

    public Expression getFetch() {
        return this.fetch;
    }

    public Expression getOffset() {
        return this.offset;
    }

    @Override
    public int getEdgeId() {
        return this.edgeId;
    }

    @Override
    public boolean isSender() {
        return false;
    }

    @Override
    public void visit(PlanNodeVisitor visitor) {
        visitor.onReceiveSortMergeNode(this);
    }

    @Override
    public PlanNodeSchema getSchema0() {
        return new PlanNodeSchema(this.fieldTypes);
    }

    @Override
    public void writeData0(ObjectDataOutput out) throws IOException {
        int i;
        out.writeInt(this.edgeId);
        SerializationUtil.writeList(this.fieldTypes, out);
        out.writeInt(this.columnIndexes.length);
        for (i = 0; i < this.columnIndexes.length; ++i) {
            out.writeInt(this.columnIndexes[i]);
        }
        out.writeInt(this.ascs.length);
        for (i = 0; i < this.ascs.length; ++i) {
            out.writeBoolean(this.ascs[i]);
        }
        out.writeObject(this.fetch);
        out.writeObject(this.offset);
    }

    @Override
    public void readData0(ObjectDataInput in) throws IOException {
        this.edgeId = in.readInt();
        this.fieldTypes = SerializationUtil.readList(in);
        int columnIndexesLength = in.readInt();
        this.columnIndexes = new int[columnIndexesLength];
        for (int i = 0; i < columnIndexesLength; ++i) {
            this.columnIndexes[i] = in.readInt();
        }
        int ascsLength = in.readInt();
        this.ascs = new boolean[ascsLength];
        for (int i = 0; i < ascsLength; ++i) {
            this.ascs[i] = in.readBoolean();
        }
        this.fetch = (Expression)in.readObject();
        this.offset = (Expression)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 62;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.edgeId, this.columnIndexes, this.fieldTypes, this.ascs, this.fetch, this.offset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReceiveSortMergePlanNode that = (ReceiveSortMergePlanNode)o;
        return this.id == that.id && this.edgeId == that.edgeId && Arrays.equals(this.columnIndexes, that.columnIndexes) && Arrays.equals(this.ascs, that.ascs) && this.fieldTypes.equals(that.fieldTypes) && Objects.equals(this.fetch, that.fetch) && Objects.equals(this.offset, that.offset);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{id=" + this.id + ", edgeId=" + this.edgeId + ", columnIndexes=" + Arrays.toString(this.columnIndexes) + ", ascs=" + Arrays.toString(this.ascs) + ", fieldTypes=" + this.fieldTypes + ", fetch=" + this.fetch + ", offset=" + this.offset + '}';
    }
}

