/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.scan;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.exec.scan.KeyValueIterator;
import java.util.Iterator;
import java.util.Map;

public class MapScanExecIterator
implements KeyValueIterator {
    private final MapContainer map;
    private final Iterator<Integer> partsIterator;
    private final InternalSerializationService serializationService;
    private final long now = Clock.currentTimeMillis();
    private RecordStore currentRecordStore;
    private Iterator<Map.Entry<Data, Record<Object>>> currentRecordStoreIterator;
    private Data currentKeyData;
    private Object currentValue;
    private Data currentValueData;
    private Data nextKeyData;
    private Object nextValue;
    private Data nextValueData;
    private boolean useCachedValues;

    public MapScanExecIterator(MapContainer map, Iterator<Integer> partsIterator, InternalSerializationService serializationService) {
        this.map = map;
        this.partsIterator = partsIterator;
        this.serializationService = serializationService;
        this.advance0(true);
    }

    @Override
    public boolean tryAdvance() {
        if (!this.done()) {
            this.currentKeyData = this.nextKeyData;
            this.currentValue = this.nextValue;
            this.currentValueData = this.nextValueData;
            this.advance0(false);
            return true;
        }
        return false;
    }

    @Override
    public boolean done() {
        return this.nextKeyData == null;
    }

    private void advance0(boolean first) {
        while (true) {
            if (this.currentRecordStoreIterator == null) {
                if (!this.partsIterator.hasNext()) {
                    this.nextKeyData = null;
                    this.nextValue = null;
                    this.nextValueData = null;
                    return;
                }
                int nextPart = this.partsIterator.next();
                boolean isOwned = this.map.getMapServiceContext().getCachedOwnedPartitions().contains(nextPart);
                if (!isOwned) {
                    throw QueryException.error(1005, "Partition was migrated while a query was executed: Partition is not owned by member: " + nextPart).markInvalidate();
                }
                if (first) {
                    this.useCachedValues = this.map.isUseCachedDeserializedValuesEnabled(nextPart);
                }
                this.currentRecordStore = this.map.getMapServiceContext().getRecordStore(nextPart, this.map.getName());
                if (this.currentRecordStore == null) continue;
                try {
                    this.currentRecordStore.checkIfLoaded();
                }
                catch (RetryableHazelcastException e) {
                    throw QueryException.error(1007, "Map loading is in progress: " + this.map.getName(), e);
                }
                this.currentRecordStoreIterator = this.currentRecordStore.getStorage().mutationTolerantIterator();
            }
            assert (this.currentRecordStoreIterator != null);
            while (this.currentRecordStoreIterator.hasNext()) {
                Map.Entry<Data, Record<Object>> entry = this.currentRecordStoreIterator.next();
                if (this.currentRecordStore.isExpired(entry.getKey(), this.now, false)) continue;
                this.nextKeyData = entry.getKey();
                Record<Object> record = entry.getValue();
                Object object = this.nextValue = this.useCachedValues ? Records.getValueOrCachedValue(record, this.serializationService) : record.getValue();
                if (this.nextValue instanceof Data) {
                    this.nextValueData = (Data)this.nextValue;
                    this.nextValue = null;
                } else {
                    Object possiblyData = record.getValue();
                    this.nextValueData = possiblyData instanceof Data ? (Data)possiblyData : null;
                }
                return;
            }
            this.currentRecordStore = null;
            this.currentRecordStoreIterator = null;
        }
    }

    @Override
    public Object getKey() {
        return null;
    }

    @Override
    public Data getKeyData() {
        return this.currentKeyData;
    }

    @Override
    public Object getValue() {
        return this.currentValue;
    }

    @Override
    public Data getValueData() {
        return this.currentValueData;
    }
}

