/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.scan;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.sql.impl.exec.scan.AbstractMapScanExec;
import com.hazelcast.sql.impl.exec.scan.KeyValueIterator;
import com.hazelcast.sql.impl.exec.scan.MapScanExecUtils;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.List;

public class MapScanExec
extends AbstractMapScanExec {
    protected final MapContainer map;
    protected final PartitionIdSet partitions;

    public MapScanExec(int id, MapContainer map, PartitionIdSet partitions, QueryTargetDescriptor keyDescriptor, QueryTargetDescriptor valueDescriptor, List<QueryPath> fieldPaths, List<QueryDataType> fieldTypes, List<Integer> projects, Expression<Boolean> filter, InternalSerializationService serializationService) {
        super(id, map.getName(), keyDescriptor, valueDescriptor, fieldPaths, fieldTypes, projects, filter, serializationService);
        this.map = map;
        this.partitions = partitions;
    }

    @Override
    protected Extractors createExtractors() {
        return MapScanExecUtils.createExtractors(this.map);
    }

    @Override
    protected int getMigrationStamp() {
        return this.map.getMapServiceContext().getService().getMigrationStamp();
    }

    @Override
    protected boolean validateMigrationStamp(int migrationStamp) {
        return this.map.getMapServiceContext().getService().validateMigrationStamp(migrationStamp);
    }

    @Override
    protected KeyValueIterator createIterator() {
        return MapScanExecUtils.createIterator(this.map, this.partitions, this.serializationService);
    }

    @Override
    protected boolean isDestroyed() {
        return this.map.isDestroyed();
    }

    public MapContainer getMap() {
        return this.map;
    }

    public PartitionIdSet getPartitions() {
        return this.partitions;
    }
}

