/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl;

import com.hazelcast.cluster.Member;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.partition.Partition;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlColumnMetadata;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.schema.TableResolver;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.version.MemberVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;

public final class QueryUtils {
    public static final String CATALOG = "hazelcast";
    public static final String SCHEMA_NAME_PARTITIONED = "partitioned";
    public static final String WORKER_TYPE_FRAGMENT = "query-fragment-thread";
    public static final String WORKER_TYPE_SYSTEM = "query-system-thread";
    public static final String WORKER_TYPE_STATE_CHECKER = "query-state-checker";

    private QueryUtils() {
    }

    public static String workerName(String instanceName, String workerType) {
        return instanceName + "-" + workerType;
    }

    public static String workerName(String instanceName, String workerType, long index) {
        return instanceName + "-" + workerType + "-" + index;
    }

    public static HazelcastSqlException toPublicException(Throwable e, UUID localMemberId) {
        if (e instanceof HazelcastSqlException) {
            return (HazelcastSqlException)e;
        }
        if (e instanceof QueryException) {
            QueryException e0 = (QueryException)e;
            UUID originatingMemberId = e0.getOriginatingMemberId();
            if (originatingMemberId == null) {
                originatingMemberId = localMemberId;
            }
            return new HazelcastSqlException(originatingMemberId, e0.getCode(), e0.getMessage(), e);
        }
        return new HazelcastSqlException(localMemberId, -1, e.getMessage(), e);
    }

    public static SqlColumnMetadata getColumnMetadata(String columnName, QueryDataType columnType, boolean columnIsNullable) {
        return new SqlColumnMetadata(columnName, columnType.getTypeFamily().getPublicType(), columnIsNullable);
    }

    public static Map<UUID, PartitionIdSet> createPartitionMap(NodeEngine nodeEngine, @Nullable MemberVersion localMemberVersion, boolean failOnUnassignedPartition) {
        Set<Partition> parts = nodeEngine.getHazelcastInstance().getPartitionService().getPartitions();
        int partCnt = parts.size();
        LinkedHashMap<UUID, PartitionIdSet> partMap = new LinkedHashMap<UUID, PartitionIdSet>();
        for (Partition part : parts) {
            Member owner = part.getOwner();
            if (owner == null) {
                if (!failOnUnassignedPartition) continue;
                throw QueryException.error(1005, "Partition is not assigned to any member: " + part.getPartitionId()).markInvalidate();
            }
            if (localMemberVersion != null && !localMemberVersion.equals(owner.getVersion())) {
                UUID localMemberId = nodeEngine.getLocalMember().getUuid();
                throw QueryException.error("Cannot execute SQL query when members have different versions (make sure that all members have the same version) {localMemberId=" + localMemberId + ", localMemberVersion=" + localMemberVersion + ", remoteMemberId=" + owner.getUuid() + ", remoteMemberVersion=" + owner.getVersion() + "}");
            }
            partMap.computeIfAbsent(owner.getUuid(), key -> new PartitionIdSet(partCnt)).add(part.getPartitionId());
        }
        return partMap;
    }

    public static List<List<String>> prepareSearchPaths(List<List<String>> currentSearchPaths, List<TableResolver> tableResolvers) {
        ArrayList<List<String>> res = new ArrayList<List<String>>();
        if (currentSearchPaths != null) {
            res.addAll(currentSearchPaths);
        }
        if (tableResolvers != null) {
            for (TableResolver tableResolver : tableResolvers) {
                res.addAll(tableResolver.getDefaultSearchPaths());
            }
        }
        res.add(Collections.singletonList(CATALOG));
        res.add(Collections.emptyList());
        return res;
    }
}

