/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.hc.client5.http.impl;

import com.hazelcast.org.apache.hc.client5.http.SchemePortResolver;
import com.hazelcast.org.apache.hc.core5.annotation.Contract;
import com.hazelcast.org.apache.hc.core5.annotation.ThreadingBehavior;
import com.hazelcast.org.apache.hc.core5.http.HttpHost;
import com.hazelcast.org.apache.hc.core5.http.URIScheme;
import com.hazelcast.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultSchemePortResolver
implements SchemePortResolver {
    public static final DefaultSchemePortResolver INSTANCE = new DefaultSchemePortResolver();

    @Override
    public int resolve(HttpHost host) {
        Args.notNull(host, "HTTP host");
        int port = host.getPort();
        if (port > 0) {
            return port;
        }
        String name = host.getSchemeName();
        if (URIScheme.HTTP.same(name)) {
            return 80;
        }
        if (URIScheme.HTTPS.same(name)) {
            return 443;
        }
        return -1;
    }
}

