/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.util;

import com.hazelcast.com.google.common.collect.HashMultimap;
import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.com.google.common.collect.Multimap;
import com.hazelcast.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlOperatorTable;
import com.hazelcast.org.apache.calcite.sql.SqlSyntax;
import com.hazelcast.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.hazelcast.org.apache.calcite.sql.validate.SqlNameMatcher;
import com.hazelcast.org.apache.calcite.util.Pair;
import com.hazelcast.org.apache.calcite.util.Util;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Locale;

public abstract class ReflectiveSqlOperatorTable
implements SqlOperatorTable {
    public static final String IS_NAME = "INFORMATION_SCHEMA";
    private final Multimap<CaseSensitiveKey, SqlOperator> caseSensitiveOperators = HashMultimap.create();
    private final Multimap<CaseInsensitiveKey, SqlOperator> caseInsensitiveOperators = HashMultimap.create();

    protected ReflectiveSqlOperatorTable() {
    }

    public final void init() {
        for (Field field : this.getClass().getFields()) {
            try {
                SqlOperator op;
                if (SqlFunction.class.isAssignableFrom(field.getType())) {
                    op = (SqlFunction)field.get(this);
                    if (op == null) continue;
                    this.register(op);
                    continue;
                }
                if (!SqlOperator.class.isAssignableFrom(field.getType())) continue;
                op = (SqlOperator)field.get(this);
                this.register(op);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                Util.throwIfUnchecked(e.getCause());
                throw new RuntimeException(e.getCause());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void lookupOperatorOverloads(SqlIdentifier opName, SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList, SqlNameMatcher nameMatcher) {
        String simpleName;
        if (opName.names.size() > 1) {
            if (!((String)opName.names.get(opName.names.size() - 2)).equals(IS_NAME)) return;
            simpleName = Util.last(opName.names);
        } else {
            simpleName = opName.getSimple();
        }
        Collection<SqlOperator> list = this.lookUpOperators(simpleName, syntax, nameMatcher);
        if (list.isEmpty()) {
            return;
        }
        for (SqlOperator op : list) {
            if (op.getSyntax() == syntax) {
                operatorList.add(op);
                continue;
            }
            if (syntax != SqlSyntax.FUNCTION || !(op instanceof SqlFunction)) continue;
            operatorList.add(op);
        }
        switch (syntax) {
            case BINARY: 
            case PREFIX: 
            case POSTFIX: {
                for (SqlOperator extra : this.lookUpOperators(simpleName, syntax, nameMatcher)) {
                    if (extra == null || operatorList.contains(extra)) continue;
                    operatorList.add(extra);
                }
                return;
            }
        }
    }

    private Collection<SqlOperator> lookUpOperators(String name, SqlSyntax syntax, SqlNameMatcher nameMatcher) {
        if (nameMatcher.isCaseSensitive() && !(this instanceof SqlStdOperatorTable)) {
            return this.caseSensitiveOperators.get(new CaseSensitiveKey(name, syntax));
        }
        return this.caseInsensitiveOperators.get(new CaseInsensitiveKey(name, syntax));
    }

    public void register(SqlOperator op) {
        this.caseSensitiveOperators.put(new CaseSensitiveKey(op.getName(), op.getSyntax()), op);
        this.caseInsensitiveOperators.put(new CaseInsensitiveKey(op.getName(), op.getSyntax()), op);
    }

    @Override
    public List<SqlOperator> getOperatorList() {
        return ImmutableList.copyOf(this.caseSensitiveOperators.values());
    }

    private static SqlSyntax normalize(SqlSyntax syntax) {
        switch (syntax) {
            case BINARY: 
            case PREFIX: 
            case POSTFIX: {
                return syntax;
            }
        }
        return SqlSyntax.FUNCTION;
    }

    private static class CaseSensitiveKey
    extends Pair<String, SqlSyntax> {
        CaseSensitiveKey(String name, SqlSyntax syntax) {
            super(name, ReflectiveSqlOperatorTable.normalize(syntax));
        }
    }

    private static class CaseInsensitiveKey
    extends Pair<String, SqlSyntax> {
        CaseInsensitiveKey(String name, SqlSyntax syntax) {
            super(name.toUpperCase(Locale.ROOT), ReflectiveSqlOperatorTable.normalize(syntax));
        }
    }
}

