/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.type;

import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFamily;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeImpl;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypePrecedenceList;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeExplicitPrecedenceList;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public abstract class AbstractSqlType
extends RelDataTypeImpl
implements Cloneable,
Serializable {
    protected final SqlTypeName typeName;
    protected boolean isNullable;

    protected AbstractSqlType(SqlTypeName typeName, boolean isNullable, List<? extends RelDataTypeField> fields) {
        super(fields);
        this.typeName = Objects.requireNonNull(typeName);
        this.isNullable = isNullable || typeName == SqlTypeName.NULL;
    }

    @Override
    public SqlTypeName getSqlTypeName() {
        return this.typeName;
    }

    @Override
    public boolean isNullable() {
        return this.isNullable;
    }

    @Override
    public RelDataTypeFamily getFamily() {
        return this.typeName.getFamily();
    }

    @Override
    public RelDataTypePrecedenceList getPrecedenceList() {
        RelDataTypePrecedenceList list = SqlTypeExplicitPrecedenceList.getListForType(this);
        if (list != null) {
            return list;
        }
        return super.getPrecedenceList();
    }
}

