/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql;

import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlInsertKeyword;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlNodeList;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.SqlSelect;
import com.hazelcast.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.org.apache.calcite.util.ImmutableNullableList;
import java.util.List;

public class SqlInsert
extends SqlCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("INSERT", SqlKind.INSERT);
    SqlNodeList keywords;
    SqlNode targetTable;
    SqlNode source;
    SqlNodeList columnList;

    public SqlInsert(SqlParserPos pos, SqlNodeList keywords, SqlNode targetTable, SqlNode source, SqlNodeList columnList) {
        super(pos);
        this.keywords = keywords;
        this.targetTable = targetTable;
        this.source = source;
        this.columnList = columnList;
        assert (keywords != null);
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.INSERT;
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.of(this.keywords, this.targetTable, this.source, this.columnList);
    }

    public final boolean isUpsert() {
        return this.getModifierNode(SqlInsertKeyword.UPSERT) != null;
    }

    @Override
    public void setOperand(int i, SqlNode operand) {
        switch (i) {
            case 0: {
                this.keywords = (SqlNodeList)operand;
                break;
            }
            case 1: {
                assert (operand instanceof SqlIdentifier);
                this.targetTable = operand;
                break;
            }
            case 2: {
                this.source = operand;
                break;
            }
            case 3: {
                this.columnList = (SqlNodeList)operand;
                break;
            }
            default: {
                throw new AssertionError(i);
            }
        }
    }

    public SqlNode getTargetTable() {
        return this.targetTable;
    }

    public SqlNode getSource() {
        return this.source;
    }

    public void setSource(SqlSelect source) {
        this.source = source;
    }

    public SqlNodeList getTargetColumnList() {
        return this.columnList;
    }

    public final SqlNode getModifierNode(SqlInsertKeyword modifier) {
        for (SqlNode keyword : this.keywords) {
            SqlInsertKeyword keyword2 = ((SqlLiteral)keyword).symbolValue(SqlInsertKeyword.class);
            if (keyword2 != modifier) continue;
            return keyword;
        }
        return null;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.startList(SqlWriter.FrameTypeEnum.SELECT);
        writer.sep(this.isUpsert() ? "UPSERT INTO" : "INSERT INTO");
        int opLeft = this.getOperator().getLeftPrec();
        int opRight = this.getOperator().getRightPrec();
        this.targetTable.unparse(writer, opLeft, opRight);
        if (this.columnList != null) {
            this.columnList.unparse(writer, opLeft, opRight);
        }
        writer.newlineAndIndent();
        this.source.unparse(writer, 0, 0);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateInsert(this);
    }
}

