/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.rules;

import com.hazelcast.com.google.common.base.Predicate;
import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableInterpreter;
import com.hazelcast.org.apache.calcite.interpreter.Bindables;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.rel.core.Filter;
import com.hazelcast.org.apache.calcite.rel.core.RelFactories;
import com.hazelcast.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexUtil;
import com.hazelcast.org.apache.calcite.schema.FilterableTable;
import com.hazelcast.org.apache.calcite.schema.ProjectableFilterableTable;
import com.hazelcast.org.apache.calcite.tools.RelBuilderFactory;
import com.hazelcast.org.apache.calcite.util.ImmutableIntList;
import com.hazelcast.org.apache.calcite.util.mapping.Mapping;
import com.hazelcast.org.apache.calcite.util.mapping.Mappings;
import java.util.List;

public abstract class FilterTableScanRule
extends RelOptRule {
    @Deprecated
    public static final Predicate<TableScan> PREDICATE = FilterTableScanRule::test;
    public static final FilterTableScanRule INSTANCE = new FilterTableScanRule(FilterTableScanRule.operand(Filter.class, FilterTableScanRule.operandJ(TableScan.class, null, FilterTableScanRule::test, FilterTableScanRule.none()), new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, "FilterTableScanRule"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            TableScan scan = (TableScan)call.rel(1);
            this.apply(call, filter, scan);
        }
    };
    public static final FilterTableScanRule INTERPRETER = new FilterTableScanRule(FilterTableScanRule.operand(Filter.class, FilterTableScanRule.operand(EnumerableInterpreter.class, FilterTableScanRule.operandJ(TableScan.class, null, FilterTableScanRule::test, FilterTableScanRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, "FilterTableScanRule:interpreter"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            TableScan scan = (TableScan)call.rel(2);
            this.apply(call, filter, scan);
        }
    };

    @Deprecated
    protected FilterTableScanRule(RelOptRuleOperand operand, String description) {
        this(operand, RelFactories.LOGICAL_BUILDER, description);
    }

    protected FilterTableScanRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description) {
        super(operand, relBuilderFactory, description);
    }

    public static boolean test(TableScan scan) {
        RelOptTable table = scan.getTable();
        return table.unwrap(FilterableTable.class) != null || table.unwrap(ProjectableFilterableTable.class) != null;
    }

    protected void apply(RelOptRuleCall call, Filter filter, TableScan scan) {
        ImmutableIntList projects;
        ImmutableList.Builder filters = ImmutableList.builder();
        if (scan instanceof Bindables.BindableTableScan) {
            Bindables.BindableTableScan bindableScan = (Bindables.BindableTableScan)scan;
            filters.addAll(bindableScan.filters);
            projects = bindableScan.projects;
        } else {
            projects = scan.identity();
        }
        Mapping mapping = Mappings.target(projects, scan.getTable().getRowType().getFieldCount());
        filters.add(RexUtil.apply((Mappings.TargetMapping)mapping.inverse(), filter.getCondition()));
        call.transformTo(Bindables.BindableTableScan.create(scan.getCluster(), scan.getTable(), (List<RexNode>)((Object)filters.build()), projects));
    }
}

