/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.plan.volcano;

import com.hazelcast.com.google.common.collect.HashMultimap;
import com.hazelcast.com.google.common.collect.ImmutableSet;
import com.hazelcast.com.google.common.collect.Multimap;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.plan.volcano.RelSubset;
import com.hazelcast.org.apache.calcite.plan.volcano.VolcanoPlanner;
import com.hazelcast.org.apache.calcite.plan.volcano.VolcanoPlannerPhase;
import com.hazelcast.org.apache.calcite.plan.volcano.VolcanoRuleMatch;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.rules.SubstitutionRule;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.org.apache.calcite.util.trace.CalciteTrace;
import com.hazelcast.org.slf4j.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

class RuleQueue {
    private static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    private static final Set<String> ALL_RULES = ImmutableSet.of("<ALL RULES>");
    final Map<VolcanoPlannerPhase, PhaseMatchList> matchListMap = new EnumMap<VolcanoPlannerPhase, PhaseMatchList>(VolcanoPlannerPhase.class);
    private final VolcanoPlanner planner;
    private final Map<VolcanoPlannerPhase, Set<String>> phaseRuleMapping;

    RuleQueue(VolcanoPlanner planner) {
        this.planner = planner;
        this.phaseRuleMapping = new EnumMap<VolcanoPlannerPhase, Set<String>>(VolcanoPlannerPhase.class);
        for (VolcanoPlannerPhase phase : VolcanoPlannerPhase.values()) {
            this.phaseRuleMapping.put(phase, new HashSet());
        }
        planner.getPhaseRuleMappingInitializer().initialize(this.phaseRuleMapping);
        for (VolcanoPlannerPhase phase : VolcanoPlannerPhase.values()) {
            if (this.phaseRuleMapping.get((Object)phase).isEmpty()) {
                this.phaseRuleMapping.put(phase, ALL_RULES);
            }
            PhaseMatchList matchList = new PhaseMatchList(phase);
            this.matchListMap.put(phase, matchList);
        }
    }

    public void clear() {
        for (PhaseMatchList matchList : this.matchListMap.values()) {
            matchList.clear();
        }
    }

    public void phaseCompleted(VolcanoPlannerPhase phase) {
        this.matchListMap.get((Object)phase).clear();
    }

    void addMatch(VolcanoRuleMatch match) {
        String matchName = match.toString();
        for (PhaseMatchList matchList : this.matchListMap.values()) {
            String ruleDescription;
            Set<String> phaseRuleSet = this.phaseRuleMapping.get((Object)matchList.phase);
            if (phaseRuleSet != ALL_RULES && !phaseRuleSet.contains(ruleDescription = match.getRule().toString()) || !matchList.names.add(matchName)) continue;
            LOGGER.trace("{} Rule-match queued: {}", (Object)matchList.phase.toString(), (Object)matchName);
            matchList.offer(match);
            matchList.matchMap.put(this.planner.getSubset(match.rels[0]), match);
        }
    }

    VolcanoRuleMatch popMatch(VolcanoPlannerPhase phase) {
        VolcanoRuleMatch match;
        this.dumpPlannerState();
        PhaseMatchList phaseMatchList = this.matchListMap.get((Object)phase);
        if (phaseMatchList == null) {
            throw new AssertionError((Object)("Used match list for phase " + (Object)((Object)phase) + " after phase complete"));
        }
        while (true) {
            if (phaseMatchList.size() == 0) {
                return null;
            }
            this.dumpRuleQueue(phaseMatchList);
            match = phaseMatchList.poll();
            if (!this.skipMatch(match)) break;
            LOGGER.debug("Skip match: {}", (Object)match);
        }
        phaseMatchList.matchMap.remove(this.planner.getSubset(match.rels[0]), match);
        LOGGER.debug("Pop match: {}", (Object)match);
        return match;
    }

    private void dumpRuleQueue(PhaseMatchList phaseMatchList) {
        if (LOGGER.isTraceEnabled()) {
            StringBuilder b = new StringBuilder();
            b.append("Rule queue:");
            for (VolcanoRuleMatch rule : phaseMatchList.preQueue) {
                b.append("\n");
                b.append(rule);
            }
            for (VolcanoRuleMatch rule : phaseMatchList.queue) {
                b.append("\n");
                b.append(rule);
            }
            LOGGER.trace(b.toString());
        }
    }

    private void dumpPlannerState() {
        if (LOGGER.isTraceEnabled()) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.planner.dump(pw);
            pw.flush();
            LOGGER.trace(sw.toString());
            this.planner.getRoot().getCluster().invalidateMetadataQuery();
        }
    }

    private boolean skipMatch(VolcanoRuleMatch match) {
        for (RelNode rel : match.rels) {
            if (!this.planner.prunedNodes.contains(rel)) continue;
            return true;
        }
        ArrayDeque<RelSubset> subsets = new ArrayDeque<RelSubset>();
        try {
            this.checkDuplicateSubsets(subsets, match.rule.getOperand(), match.rels);
        }
        catch (Util.FoundOne e) {
            return true;
        }
        return false;
    }

    private void checkDuplicateSubsets(Deque<RelSubset> subsets, RelOptRuleOperand operand, RelNode[] rels) {
        RelSubset subset = this.planner.getSubset(rels[operand.ordinalInRule]);
        if (subsets.contains(subset)) {
            throw Util.FoundOne.NULL;
        }
        if (!operand.getChildOperands().isEmpty()) {
            subsets.push(subset);
            for (RelOptRuleOperand childOperand : operand.getChildOperands()) {
                this.checkDuplicateSubsets(subsets, childOperand, rels);
            }
            RelSubset x = subsets.pop();
            assert (x == subset);
        }
    }

    private static class PhaseMatchList {
        final VolcanoPlannerPhase phase;
        private final Queue<VolcanoRuleMatch> preQueue = new LinkedList<VolcanoRuleMatch>();
        private final Queue<VolcanoRuleMatch> queue = new LinkedList<VolcanoRuleMatch>();
        final Set<String> names = new HashSet<String>();
        final Multimap<RelSubset, VolcanoRuleMatch> matchMap = HashMultimap.create();

        PhaseMatchList(VolcanoPlannerPhase phase) {
            this.phase = phase;
        }

        int size() {
            return this.preQueue.size() + this.queue.size();
        }

        VolcanoRuleMatch poll() {
            VolcanoRuleMatch match = this.preQueue.poll();
            if (match == null) {
                match = this.queue.poll();
            }
            return match;
        }

        void offer(VolcanoRuleMatch match) {
            if (match.getRule() instanceof SubstitutionRule) {
                this.preQueue.offer(match);
            } else {
                this.queue.offer(match);
            }
        }

        void clear() {
            this.preQueue.clear();
            this.queue.clear();
            this.names.clear();
            this.matchMap.clear();
        }
    }
}

