/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.plan;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperandChildPolicy;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperandChildren;
import com.hazelcast.org.apache.calcite.plan.RelTrait;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class RelOptRuleOperand {
    private RelOptRuleOperand parent;
    private RelOptRule rule;
    private final Predicate<RelNode> predicate;
    public int[] solveOrder;
    public int ordinalInParent;
    public int ordinalInRule;
    private final RelTrait trait;
    private final Class<? extends RelNode> clazz;
    private final ImmutableList<RelOptRuleOperand> children;
    public final RelOptRuleOperandChildPolicy childPolicy;

    @Deprecated
    protected <R extends RelNode> RelOptRuleOperand(Class<R> clazz, RelTrait trait, Predicate<? super R> predicate, RelOptRuleOperandChildren children) {
        this(clazz, trait, predicate, children.policy, children.operands);
    }

    <R extends RelNode> RelOptRuleOperand(Class<R> clazz, RelTrait trait, Predicate<? super R> predicate, RelOptRuleOperandChildPolicy childPolicy, ImmutableList<RelOptRuleOperand> children) {
        assert (clazz != null);
        switch (childPolicy) {
            case ANY: {
                break;
            }
            case LEAF: {
                assert (children.size() == 0);
                break;
            }
            case UNORDERED: {
                assert (children.size() == 1);
                break;
            }
            default: {
                assert (children.size() > 0);
                break;
            }
        }
        this.childPolicy = childPolicy;
        this.clazz = Objects.requireNonNull(clazz);
        this.trait = trait;
        this.predicate = Objects.requireNonNull(predicate);
        this.children = children;
        for (RelOptRuleOperand child : this.children) {
            assert (child.parent == null) : "cannot re-use operands";
            child.parent = this;
        }
    }

    public RelOptRuleOperand getParent() {
        return this.parent;
    }

    public void setParent(RelOptRuleOperand parent) {
        this.parent = parent;
    }

    public RelOptRule getRule() {
        return this.rule;
    }

    public void setRule(RelOptRule rule) {
        this.rule = rule;
    }

    public int hashCode() {
        return Objects.hash(this.clazz, this.trait, this.children);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RelOptRuleOperand)) {
            return false;
        }
        RelOptRuleOperand that = (RelOptRuleOperand)obj;
        return this.clazz == that.clazz && Objects.equals(this.trait, that.trait) && this.children.equals(that.children);
    }

    public Class<? extends RelNode> getMatchedClass() {
        return this.clazz;
    }

    public List<RelOptRuleOperand> getChildOperands() {
        return this.children;
    }

    public boolean matches(RelNode rel) {
        if (!this.clazz.isInstance(rel)) {
            return false;
        }
        if (this.trait != null && !rel.getTraitSet().contains(this.trait)) {
            return false;
        }
        return this.predicate.test(rel);
    }
}

