/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.materialize;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.materialize.LatticeChildNode;
import com.hazelcast.org.apache.calcite.materialize.LatticeNode;
import com.hazelcast.org.apache.calcite.materialize.LatticeSpace;
import com.hazelcast.org.apache.calcite.materialize.MutableNode;
import com.hazelcast.org.apache.calcite.materialize.Path;
import com.hazelcast.org.apache.calcite.materialize.Step;
import com.hazelcast.org.apache.calcite.util.Litmus;
import java.util.ArrayList;
import java.util.List;

public class LatticeRootNode
extends LatticeNode {
    public final ImmutableList<LatticeNode> descendants;
    final ImmutableList<Path> paths;

    LatticeRootNode(LatticeSpace space, MutableNode mutableNode) {
        super(space, null, mutableNode);
        ImmutableList.Builder<LatticeNode> b = ImmutableList.builder();
        this.flattenTo(b);
        this.descendants = b.build();
        this.paths = this.createPaths(space);
    }

    private ImmutableList<Path> createPaths(LatticeSpace space) {
        ArrayList<Step> steps = new ArrayList<Step>();
        ArrayList<Path> paths = new ArrayList<Path>();
        this.createPathsRecurse(space, steps, paths);
        assert (steps.isEmpty());
        return ImmutableList.copyOf(paths);
    }

    @Override
    void use(List<LatticeNode> usedNodes) {
        if (!usedNodes.contains(this)) {
            usedNodes.add(this);
        }
    }

    boolean isValid(Litmus litmus) {
        for (int i = 0; i < this.descendants.size(); ++i) {
            LatticeNode node = (LatticeNode)this.descendants.get(i);
            if (i == 0) {
                if (node == this) continue;
                return litmus.fail("node 0 should be root", new Object[0]);
            }
            if (!(node instanceof LatticeChildNode)) {
                return litmus.fail("node after 0 should be child", new Object[0]);
            }
            LatticeChildNode child = (LatticeChildNode)node;
            if (((ImmutableList)this.descendants.subList(0, i)).contains(child.parent)) continue;
            return litmus.fail("parent not in preceding list", new Object[0]);
        }
        return litmus.succeed();
    }

    public boolean contains(LatticeRootNode node) {
        return this.paths.containsAll(node.paths);
    }
}

