/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.adapter.enumerable;

import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableRel;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import com.hazelcast.org.apache.calcite.adapter.enumerable.EnumerableTableScan;
import com.hazelcast.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import com.hazelcast.org.apache.calcite.adapter.enumerable.PhysType;
import com.hazelcast.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import com.hazelcast.org.apache.calcite.adapter.java.JavaTypeFactory;
import com.hazelcast.org.apache.calcite.linq4j.tree.BlockBuilder;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.org.apache.calcite.linq4j.tree.Expressions;
import com.hazelcast.org.apache.calcite.linq4j.tree.ParameterExpression;
import com.hazelcast.org.apache.calcite.linq4j.tree.Types;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.prepare.Prepare;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.TableModify;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.schema.ModifiableTable;
import com.hazelcast.org.apache.calcite.util.BuiltInMethod;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EnumerableTableModify
extends TableModify
implements EnumerableRel {
    public EnumerableTableModify(RelOptCluster cluster, RelTraitSet traits, RelOptTable table, Prepare.CatalogReader catalogReader, RelNode child, TableModify.Operation operation, List<String> updateColumnList, List<RexNode> sourceExpressionList, boolean flattened) {
        super(cluster, traits, table, catalogReader, child, operation, updateColumnList, sourceExpressionList, flattened);
        assert (child.getConvention() instanceof EnumerableConvention);
        assert (this.getConvention() instanceof EnumerableConvention);
        ModifiableTable modifiableTable = table.unwrap(ModifiableTable.class);
        if (modifiableTable == null) {
            throw new AssertionError();
        }
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableTableModify(this.getCluster(), traitSet, this.getTable(), this.getCatalogReader(), EnumerableTableModify.sole(inputs), this.getOperation(), this.getUpdateColumnList(), this.getSourceExpressionList(), this.isFlattened());
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        Method method;
        Expression convertedChildExp;
        PhysType physType;
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel.Result result = implementor.visitChild(this, 0, (EnumerableRel)this.getInput(), pref);
        Expression childExp = builder.append("child", result.block);
        ParameterExpression collectionParameter = Expressions.parameter(Collection.class, builder.newName("collection"));
        Expression expression = this.table.getExpression(ModifiableTable.class);
        assert (expression != null);
        assert (ModifiableTable.class.isAssignableFrom(Types.toClass(expression.getType()))) : expression.getType();
        builder.add(Expressions.declare(16, collectionParameter, (Expression)Expressions.call(expression, BuiltInMethod.MODIFIABLE_TABLE_GET_MODIFIABLE_COLLECTION.method, new Expression[0])));
        Expression countParameter = builder.append("count", Expressions.call((Expression)collectionParameter, "size", new Expression[0]), false);
        if (!this.getInput().getRowType().equals(this.getRowType())) {
            JavaTypeFactory typeFactory = (JavaTypeFactory)this.getCluster().getTypeFactory();
            JavaRowFormat format = EnumerableTableScan.deduceFormat(this.table);
            physType = PhysTypeImpl.of(typeFactory, this.table.getRowType(), format);
            ArrayList<Expression> expressionList = new ArrayList<Expression>();
            PhysType childPhysType = result.physType;
            ParameterExpression o_ = Expressions.parameter(childPhysType.getJavaRowType(), "o");
            int fieldCount = childPhysType.getRowType().getFieldCount();
            for (int i = 0; i < fieldCount; ++i) {
                expressionList.add(childPhysType.fieldReference(o_, i, physType.getJavaFieldType(i)));
            }
            convertedChildExp = builder.append("convertedChild", Expressions.call(childExp, BuiltInMethod.SELECT.method, Expressions.lambda(physType.record(expressionList), o_)));
        } else {
            convertedChildExp = childExp;
        }
        switch (this.getOperation()) {
            case INSERT: {
                method = BuiltInMethod.INTO.method;
                break;
            }
            case DELETE: {
                method = BuiltInMethod.REMOVE_ALL.method;
                break;
            }
            default: {
                throw new AssertionError((Object)this.getOperation());
            }
        }
        builder.add(Expressions.statement(Expressions.call(convertedChildExp, method, collectionParameter)));
        Expression updatedCountParameter = builder.append("updatedCount", Expressions.call((Expression)collectionParameter, "size", new Expression[0]), false);
        builder.add(Expressions.return_(null, Expressions.call(BuiltInMethod.SINGLETON_ENUMERABLE.method, Expressions.convert_(Expressions.condition(Expressions.greaterThanOrEqual(updatedCountParameter, countParameter), Expressions.subtract(updatedCountParameter, countParameter), Expressions.subtract(countParameter, updatedCountParameter)), Long.TYPE))));
        physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref == EnumerableRel.Prefer.ARRAY ? JavaRowFormat.ARRAY : JavaRowFormat.SCALAR);
        return implementor.result(physType, builder.toBlock());
    }
}

