/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server.tcp;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.server.ServerContext;
import com.hazelcast.logging.ILogger;

class TcpServerConnectionErrorHandler {
    private final ILogger logger;
    private final ServerContext serverContext;
    private final Address endPoint;
    private final long minInterval;
    private final int maxFaults;
    private int faults;
    private long lastFaultTime;

    TcpServerConnectionErrorHandler(ServerContext serverContext, Address endPoint) {
        this.endPoint = endPoint;
        this.serverContext = serverContext;
        this.minInterval = serverContext.getConnectionMonitorInterval();
        this.maxFaults = serverContext.getConnectionMonitorMaxFaults();
        this.logger = serverContext.getLoggingService().getLogger(this.getClass());
    }

    synchronized void onError(Throwable cause) {
        String errorMessage = "An error occurred on connection to " + this.endPoint + this.getCauseDescription(cause);
        this.logger.finest(errorMessage);
        long now = System.currentTimeMillis();
        long last = this.lastFaultTime;
        if (now - last > this.minInterval) {
            if (this.faults++ >= this.maxFaults) {
                String removeEndpointMessage = "Removing connection to endpoint " + this.endPoint + this.getCauseDescription(cause);
                this.logger.warning(removeEndpointMessage);
                this.serverContext.removeEndpoint(this.endPoint);
            }
            this.lastFaultTime = now;
        }
    }

    synchronized void reset() {
        String resetMessage = "Resetting connection monitor for endpoint " + this.endPoint;
        this.logger.finest(resetMessage);
        this.faults = 0;
        this.lastFaultTime = 0L;
    }

    private String getCauseDescription(Throwable cause) {
        StringBuilder s = new StringBuilder(" Cause => ");
        if (cause != null) {
            s.append(cause.getClass().getName()).append(" {").append(cause.getMessage()).append("}");
        } else {
            s.append("Unknown");
        }
        return s.append(", Error-Count: ").append(this.faults + 1).toString();
    }
}

