/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.AdvancedNetworkConfig;
import com.hazelcast.config.AuditlogConfig;
import com.hazelcast.config.CRDTReplicationConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CardinalityEstimatorConfig;
import com.hazelcast.config.ConfigPatternMatcher;
import com.hazelcast.config.DurableExecutorConfig;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.FlakeIdGeneratorConfig;
import com.hazelcast.config.HotRestartPersistenceConfig;
import com.hazelcast.config.InstanceTrackingConfig;
import com.hazelcast.config.ListConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MemberAttributeConfig;
import com.hazelcast.config.MetricsConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.PNCounterConfig;
import com.hazelcast.config.PartitionGroupConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.ReliableTopicConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SetConfig;
import com.hazelcast.config.SplitBrainProtectionConfig;
import com.hazelcast.config.SqlConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.UserCodeDeploymentConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.config.YamlConfigBuilder;
import com.hazelcast.config.cp.CPSubsystemConfig;
import com.hazelcast.config.matcher.MatchingPointConfigPatternMatcher;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.internal.config.CacheSimpleConfigReadOnly;
import com.hazelcast.internal.config.CardinalityEstimatorConfigReadOnly;
import com.hazelcast.internal.config.ConfigUtils;
import com.hazelcast.internal.config.DeclarativeConfigUtil;
import com.hazelcast.internal.config.DurableExecutorConfigReadOnly;
import com.hazelcast.internal.config.ExecutorConfigReadOnly;
import com.hazelcast.internal.config.ListConfigReadOnly;
import com.hazelcast.internal.config.MapConfigReadOnly;
import com.hazelcast.internal.config.MultiMapConfigReadOnly;
import com.hazelcast.internal.config.PNCounterConfigReadOnly;
import com.hazelcast.internal.config.QueueConfigReadOnly;
import com.hazelcast.internal.config.ReliableTopicConfigReadOnly;
import com.hazelcast.internal.config.ReplicatedMapConfigReadOnly;
import com.hazelcast.internal.config.RingbufferConfigReadOnly;
import com.hazelcast.internal.config.ScheduledExecutorConfigReadOnly;
import com.hazelcast.internal.config.ServicesConfig;
import com.hazelcast.internal.config.SetConfigReadOnly;
import com.hazelcast.internal.config.TopicConfigReadOnly;
import com.hazelcast.internal.config.XmlConfigLocator;
import com.hazelcast.internal.config.YamlConfigLocator;
import com.hazelcast.internal.config.override.ExternalConfigurationOverride;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.security.jsm.HazelcastRuntimePermission;
import com.hazelcast.spi.annotation.PrivateApi;
import java.io.File;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;

public class Config {
    public static final String DEFAULT_CLUSTER_NAME = "dev";
    private URL configurationUrl;
    private File configurationFile;
    private ClassLoader classLoader;
    private Properties properties = new Properties();
    private String instanceName;
    private String clusterName = "dev";
    private NetworkConfig networkConfig = new NetworkConfig();
    private ConfigPatternMatcher configPatternMatcher = new MatchingPointConfigPatternMatcher();
    private final Map<String, MapConfig> mapConfigs = new ConcurrentHashMap<String, MapConfig>();
    private final Map<String, CacheSimpleConfig> cacheConfigs = new ConcurrentHashMap<String, CacheSimpleConfig>();
    private final Map<String, TopicConfig> topicConfigs = new ConcurrentHashMap<String, TopicConfig>();
    private final Map<String, ReliableTopicConfig> reliableTopicConfigs = new ConcurrentHashMap<String, ReliableTopicConfig>();
    private final Map<String, QueueConfig> queueConfigs = new ConcurrentHashMap<String, QueueConfig>();
    private final Map<String, MultiMapConfig> multiMapConfigs = new ConcurrentHashMap<String, MultiMapConfig>();
    private final Map<String, ListConfig> listConfigs = new ConcurrentHashMap<String, ListConfig>();
    private final Map<String, SetConfig> setConfigs = new ConcurrentHashMap<String, SetConfig>();
    private final Map<String, ExecutorConfig> executorConfigs = new ConcurrentHashMap<String, ExecutorConfig>();
    private final Map<String, DurableExecutorConfig> durableExecutorConfigs = new ConcurrentHashMap<String, DurableExecutorConfig>();
    private final Map<String, ScheduledExecutorConfig> scheduledExecutorConfigs = new ConcurrentHashMap<String, ScheduledExecutorConfig>();
    private final Map<String, ReplicatedMapConfig> replicatedMapConfigs = new ConcurrentHashMap<String, ReplicatedMapConfig>();
    private final Map<String, WanReplicationConfig> wanReplicationConfigs = new ConcurrentHashMap<String, WanReplicationConfig>();
    private final Map<String, SplitBrainProtectionConfig> splitBrainProtectionConfigs = new ConcurrentHashMap<String, SplitBrainProtectionConfig>();
    private final Map<String, RingbufferConfig> ringbufferConfigs = new ConcurrentHashMap<String, RingbufferConfig>();
    private final Map<String, CardinalityEstimatorConfig> cardinalityEstimatorConfigs = new ConcurrentHashMap<String, CardinalityEstimatorConfig>();
    private final Map<String, FlakeIdGeneratorConfig> flakeIdGeneratorConfigMap = new ConcurrentHashMap<String, FlakeIdGeneratorConfig>();
    private final Map<String, PNCounterConfig> pnCounterConfigs = new ConcurrentHashMap<String, PNCounterConfig>();
    private AdvancedNetworkConfig advancedNetworkConfig = new AdvancedNetworkConfig();
    private ServicesConfig servicesConfig = new ServicesConfig();
    private SecurityConfig securityConfig = new SecurityConfig();
    private final List<ListenerConfig> listenerConfigs = new LinkedList<ListenerConfig>();
    private PartitionGroupConfig partitionGroupConfig = new PartitionGroupConfig();
    private ManagementCenterConfig managementCenterConfig = new ManagementCenterConfig();
    private SerializationConfig serializationConfig = new SerializationConfig();
    private ManagedContext managedContext;
    private ConcurrentMap<String, Object> userContext = new ConcurrentHashMap<String, Object>();
    private MemberAttributeConfig memberAttributeConfig = new MemberAttributeConfig();
    private NativeMemoryConfig nativeMemoryConfig = new NativeMemoryConfig();
    private HotRestartPersistenceConfig hotRestartPersistenceConfig = new HotRestartPersistenceConfig();
    private UserCodeDeploymentConfig userCodeDeploymentConfig = new UserCodeDeploymentConfig();
    private CRDTReplicationConfig crdtReplicationConfig = new CRDTReplicationConfig();
    private String licenseKey;
    private boolean liteMember;
    private CPSubsystemConfig cpSubsystemConfig = new CPSubsystemConfig();
    private SqlConfig sqlConfig = new SqlConfig();
    private AuditlogConfig auditlogConfig = new AuditlogConfig();
    private MetricsConfig metricsConfig = new MetricsConfig();
    private InstanceTrackingConfig instanceTrackingConfig = new InstanceTrackingConfig();

    public Config() {
    }

    public Config(String instanceName) {
        this.instanceName = instanceName;
    }

    public static Config load() {
        return new ExternalConfigurationOverride().overwriteMemberConfig(Config.loadFromFile());
    }

    private static Config loadFromFile() {
        DeclarativeConfigUtil.validateSuffixInSystemProperty("hazelcast.config");
        XmlConfigLocator xmlConfigLocator = new XmlConfigLocator();
        YamlConfigLocator yamlConfigLocator = new YamlConfigLocator();
        if (xmlConfigLocator.locateFromSystemProperty()) {
            return new XmlConfigBuilder(xmlConfigLocator).build();
        }
        if (yamlConfigLocator.locateFromSystemProperty()) {
            return new YamlConfigBuilder(yamlConfigLocator).build();
        }
        if (xmlConfigLocator.locateInWorkDirOrOnClasspath()) {
            return new XmlConfigBuilder(xmlConfigLocator).build();
        }
        if (yamlConfigLocator.locateInWorkDirOrOnClasspath()) {
            return new YamlConfigBuilder(yamlConfigLocator).build();
        }
        xmlConfigLocator.locateDefault();
        return new XmlConfigBuilder(xmlConfigLocator).build();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Config setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public ConfigPatternMatcher getConfigPatternMatcher() {
        return this.configPatternMatcher;
    }

    public Config setConfigPatternMatcher(ConfigPatternMatcher configPatternMatcher) {
        if (configPatternMatcher == null) {
            throw new IllegalArgumentException("ConfigPatternMatcher is not allowed to be null!");
        }
        this.configPatternMatcher = configPatternMatcher;
        return this;
    }

    public String getProperty(String name) {
        String value = this.properties.getProperty(name);
        return value != null ? value : System.getProperty(name);
    }

    public Config setProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public MemberAttributeConfig getMemberAttributeConfig() {
        return this.memberAttributeConfig;
    }

    public Config setMemberAttributeConfig(MemberAttributeConfig memberAttributeConfig) {
        this.memberAttributeConfig = memberAttributeConfig;
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Config setProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public Config setInstanceName(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Config setClusterName(String clusterName) {
        this.clusterName = Preconditions.isNotNull(clusterName, "clusterName");
        return this;
    }

    public NetworkConfig getNetworkConfig() {
        return this.networkConfig;
    }

    public Config setNetworkConfig(NetworkConfig networkConfig) {
        this.networkConfig = networkConfig;
        return this;
    }

    public MapConfig findMapConfig(String name) {
        MapConfig config = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.mapConfigs, name = StringPartitioningStrategy.getBaseName(name));
        if (config != null) {
            return new MapConfigReadOnly(config);
        }
        return new MapConfigReadOnly(this.getMapConfig("default"));
    }

    public MapConfig getMapConfigOrNull(String name) {
        name = StringPartitioningStrategy.getBaseName(name);
        return ConfigUtils.lookupByPattern(this.configPatternMatcher, this.mapConfigs, name);
    }

    public MapConfig getMapConfig(String name) {
        return ConfigUtils.getConfig(this.configPatternMatcher, this.mapConfigs, name, MapConfig.class);
    }

    public Config addMapConfig(MapConfig mapConfig) {
        this.mapConfigs.put(mapConfig.getName(), mapConfig);
        return this;
    }

    public Map<String, MapConfig> getMapConfigs() {
        return this.mapConfigs;
    }

    public Config setMapConfigs(Map<String, MapConfig> mapConfigs) {
        this.mapConfigs.clear();
        this.mapConfigs.putAll(mapConfigs);
        for (Map.Entry<String, MapConfig> entry : this.mapConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public CacheSimpleConfig findCacheConfig(String name) {
        CacheSimpleConfig config = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.cacheConfigs, name = StringPartitioningStrategy.getBaseName(name));
        if (config != null) {
            return new CacheSimpleConfigReadOnly(config);
        }
        return new CacheSimpleConfigReadOnly(this.getCacheConfig("default"));
    }

    public CacheSimpleConfig findCacheConfigOrNull(String name) {
        name = StringPartitioningStrategy.getBaseName(name);
        return ConfigUtils.lookupByPattern(this.configPatternMatcher, this.cacheConfigs, name);
    }

    public CacheSimpleConfig getCacheConfig(String name) {
        return ConfigUtils.getConfig(this.configPatternMatcher, this.cacheConfigs, name, CacheSimpleConfig.class);
    }

    public Config addCacheConfig(CacheSimpleConfig cacheConfig) {
        this.cacheConfigs.put(cacheConfig.getName(), cacheConfig);
        return this;
    }

    public Map<String, CacheSimpleConfig> getCacheConfigs() {
        return this.cacheConfigs;
    }

    public Config setCacheConfigs(Map<String, CacheSimpleConfig> cacheConfigs) {
        this.cacheConfigs.clear();
        this.cacheConfigs.putAll(cacheConfigs);
        for (Map.Entry<String, CacheSimpleConfig> entry : this.cacheConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public QueueConfig findQueueConfig(String name) {
        QueueConfig config = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.queueConfigs, name = StringPartitioningStrategy.getBaseName(name));
        if (config != null) {
            return new QueueConfigReadOnly(config);
        }
        return new QueueConfigReadOnly(this.getQueueConfig("default"));
    }

    public QueueConfig getQueueConfig(String name) {
        return ConfigUtils.getConfig(this.configPatternMatcher, this.queueConfigs, name, QueueConfig.class);
    }

    public Config addQueueConfig(QueueConfig queueConfig) {
        this.queueConfigs.put(queueConfig.getName(), queueConfig);
        return this;
    }

    public Map<String, QueueConfig> getQueueConfigs() {
        return this.queueConfigs;
    }

    public Config setQueueConfigs(Map<String, QueueConfig> queueConfigs) {
        this.queueConfigs.clear();
        this.queueConfigs.putAll(queueConfigs);
        for (Map.Entry<String, QueueConfig> entry : queueConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public ListConfig findListConfig(String name) {
        ListConfig config = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.listConfigs, name = StringPartitioningStrategy.getBaseName(name));
        if (config != null) {
            return new ListConfigReadOnly(config);
        }
        return new ListConfigReadOnly(this.getListConfig("default"));
    }

    public ListConfig getListConfig(String name) {
        return ConfigUtils.getConfig(this.configPatternMatcher, this.listConfigs, name, ListConfig.class);
    }

    public Config addListConfig(ListConfig listConfig) {
        this.listConfigs.put(listConfig.getName(), listConfig);
        return this;
    }

    public Map<String, ListConfig> getListConfigs() {
        return this.listConfigs;
    }

    public Config setListConfigs(Map<String, ListConfig> listConfigs) {
        this.listConfigs.clear();
        this.listConfigs.putAll(listConfigs);
        for (Map.Entry<String, ListConfig> entry : listConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public SetConfig findSetConfig(String name) {
        SetConfig config = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.setConfigs, name = StringPartitioningStrategy.getBaseName(name));
        if (config != null) {
            return new SetConfigReadOnly(config);
        }
        return new SetConfigReadOnly(this.getSetConfig("default"));
    }

    public SetConfig getSetConfig(String name) {
        return ConfigUtils.getConfig(this.configPatternMatcher, this.setConfigs, name, SetConfig.class);
    }

    public Config addSetConfig(SetConfig setConfig) {
        this.setConfigs.put(setConfig.getName(), setConfig);
        return this;
    }

    public Map<String, SetConfig> getSetConfigs() {
        return this.setConfigs;
    }

    public Config setSetConfigs(Map<String, SetConfig> setConfigs) {
        this.setConfigs.clear();
        this.setConfigs.putAll(setConfigs);
        for (Map.Entry<String, SetConfig> entry : setConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public MultiMapConfig findMultiMapConfig(String name) {
        MultiMapConfig config = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.multiMapConfigs, name = StringPartitioningStrategy.getBaseName(name));
        if (config != null) {
            return new MultiMapConfigReadOnly(config);
        }
        return new MultiMapConfigReadOnly(this.getMultiMapConfig("default"));
    }

    public MultiMapConfig getMultiMapConfig(String name) {
        return ConfigUtils.getConfig(this.configPatternMatcher, this.multiMapConfigs, name, MultiMapConfig.class);
    }

    public Config addMultiMapConfig(MultiMapConfig multiMapConfig) {
        this.multiMapConfigs.put(multiMapConfig.getName(), multiMapConfig);
        return this;
    }

    public Map<String, MultiMapConfig> getMultiMapConfigs() {
        return this.multiMapConfigs;
    }

    public Config setMultiMapConfigs(Map<String, MultiMapConfig> multiMapConfigs) {
        this.multiMapConfigs.clear();
        this.multiMapConfigs.putAll(multiMapConfigs);
        for (Map.Entry<String, MultiMapConfig> entry : this.multiMapConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public ReplicatedMapConfig findReplicatedMapConfig(String name) {
        ReplicatedMapConfig config = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.replicatedMapConfigs, name = StringPartitioningStrategy.getBaseName(name));
        if (config != null) {
            return new ReplicatedMapConfigReadOnly(config);
        }
        return new ReplicatedMapConfigReadOnly(this.getReplicatedMapConfig("default"));
    }

    public ReplicatedMapConfig getReplicatedMapConfig(String name) {
        return ConfigUtils.getConfig(this.configPatternMatcher, this.replicatedMapConfigs, name, ReplicatedMapConfig.class);
    }

    public Config addReplicatedMapConfig(ReplicatedMapConfig replicatedMapConfig) {
        this.replicatedMapConfigs.put(replicatedMapConfig.getName(), replicatedMapConfig);
        return this;
    }

    public Map<String, ReplicatedMapConfig> getReplicatedMapConfigs() {
        return this.replicatedMapConfigs;
    }

    public Config setReplicatedMapConfigs(Map<String, ReplicatedMapConfig> replicatedMapConfigs) {
        this.replicatedMapConfigs.clear();
        this.replicatedMapConfigs.putAll(replicatedMapConfigs);
        for (Map.Entry<String, ReplicatedMapConfig> entry : this.replicatedMapConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public RingbufferConfig findRingbufferConfig(String name) {
        RingbufferConfig config = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.ringbufferConfigs, name = StringPartitioningStrategy.getBaseName(name));
        if (config != null) {
            return new RingbufferConfigReadOnly(config);
        }
        return new RingbufferConfigReadOnly(this.getRingbufferConfig("default"));
    }

    public RingbufferConfig getRingbufferConfig(String name) {
        return ConfigUtils.getConfig(this.configPatternMatcher, this.ringbufferConfigs, name, RingbufferConfig.class);
    }

    public Config addRingBufferConfig(RingbufferConfig ringbufferConfig) {
        this.ringbufferConfigs.put(ringbufferConfig.getName(), ringbufferConfig);
        return this;
    }

    public Map<String, RingbufferConfig> getRingbufferConfigs() {
        return this.ringbufferConfigs;
    }

    public Config setRingbufferConfigs(Map<String, RingbufferConfig> ringbufferConfigs) {
        this.ringbufferConfigs.clear();
        this.ringbufferConfigs.putAll(ringbufferConfigs);
        for (Map.Entry<String, RingbufferConfig> entry : ringbufferConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public TopicConfig findTopicConfig(String name) {
        TopicConfig config = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.topicConfigs, name = StringPartitioningStrategy.getBaseName(name));
        if (config != null) {
            return new TopicConfigReadOnly(config);
        }
        return new TopicConfigReadOnly(this.getTopicConfig("default"));
    }

    public TopicConfig getTopicConfig(String name) {
        return ConfigUtils.getConfig(this.configPatternMatcher, this.topicConfigs, name, TopicConfig.class);
    }

    public Config addTopicConfig(TopicConfig topicConfig) {
        this.topicConfigs.put(topicConfig.getName(), topicConfig);
        return this;
    }

    public ReliableTopicConfig findReliableTopicConfig(String name) {
        ReliableTopicConfig config = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.reliableTopicConfigs, name = StringPartitioningStrategy.getBaseName(name));
        if (config != null) {
            return new ReliableTopicConfigReadOnly(config);
        }
        return new ReliableTopicConfigReadOnly(this.getReliableTopicConfig("default"));
    }

    public ReliableTopicConfig getReliableTopicConfig(String name) {
        return ConfigUtils.getConfig(this.configPatternMatcher, this.reliableTopicConfigs, name, ReliableTopicConfig.class);
    }

    public Map<String, ReliableTopicConfig> getReliableTopicConfigs() {
        return this.reliableTopicConfigs;
    }

    public Config addReliableTopicConfig(ReliableTopicConfig topicConfig) {
        this.reliableTopicConfigs.put(topicConfig.getName(), topicConfig);
        return this;
    }

    public Config setReliableTopicConfigs(Map<String, ReliableTopicConfig> reliableTopicConfigs) {
        this.reliableTopicConfigs.clear();
        this.reliableTopicConfigs.putAll(reliableTopicConfigs);
        for (Map.Entry<String, ReliableTopicConfig> entry : reliableTopicConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public Map<String, TopicConfig> getTopicConfigs() {
        return this.topicConfigs;
    }

    public Config setTopicConfigs(Map<String, TopicConfig> topicConfigs) {
        this.topicConfigs.clear();
        this.topicConfigs.putAll(topicConfigs);
        for (Map.Entry<String, TopicConfig> entry : this.topicConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public ExecutorConfig findExecutorConfig(String name) {
        ExecutorConfig config = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.executorConfigs, name = StringPartitioningStrategy.getBaseName(name));
        if (config != null) {
            return new ExecutorConfigReadOnly(config);
        }
        return new ExecutorConfigReadOnly(this.getExecutorConfig("default"));
    }

    public DurableExecutorConfig findDurableExecutorConfig(String name) {
        DurableExecutorConfig config = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.durableExecutorConfigs, name = StringPartitioningStrategy.getBaseName(name));
        if (config != null) {
            return new DurableExecutorConfigReadOnly(config);
        }
        return new DurableExecutorConfigReadOnly(this.getDurableExecutorConfig("default"));
    }

    public ScheduledExecutorConfig findScheduledExecutorConfig(String name) {
        ScheduledExecutorConfig config = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.scheduledExecutorConfigs, name = StringPartitioningStrategy.getBaseName(name));
        if (config != null) {
            return new ScheduledExecutorConfigReadOnly(config);
        }
        return new ScheduledExecutorConfigReadOnly(this.getScheduledExecutorConfig("default"));
    }

    public CardinalityEstimatorConfig findCardinalityEstimatorConfig(String name) {
        CardinalityEstimatorConfig config = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.cardinalityEstimatorConfigs, name = StringPartitioningStrategy.getBaseName(name));
        if (config != null) {
            return new CardinalityEstimatorConfigReadOnly(config);
        }
        return new CardinalityEstimatorConfigReadOnly(this.getCardinalityEstimatorConfig("default"));
    }

    public PNCounterConfig findPNCounterConfig(String name) {
        PNCounterConfig config = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.pnCounterConfigs, name = StringPartitioningStrategy.getBaseName(name));
        if (config != null) {
            return new PNCounterConfigReadOnly(config);
        }
        return new PNCounterConfigReadOnly(this.getPNCounterConfig("default"));
    }

    public ExecutorConfig getExecutorConfig(String name) {
        return ConfigUtils.getConfig(this.configPatternMatcher, this.executorConfigs, name, ExecutorConfig.class);
    }

    public DurableExecutorConfig getDurableExecutorConfig(String name) {
        return ConfigUtils.getConfig(this.configPatternMatcher, this.durableExecutorConfigs, name, DurableExecutorConfig.class);
    }

    public ScheduledExecutorConfig getScheduledExecutorConfig(String name) {
        return ConfigUtils.getConfig(this.configPatternMatcher, this.scheduledExecutorConfigs, name, ScheduledExecutorConfig.class);
    }

    public CardinalityEstimatorConfig getCardinalityEstimatorConfig(String name) {
        return ConfigUtils.getConfig(this.configPatternMatcher, this.cardinalityEstimatorConfigs, name, CardinalityEstimatorConfig.class);
    }

    public PNCounterConfig getPNCounterConfig(String name) {
        return ConfigUtils.getConfig(this.configPatternMatcher, this.pnCounterConfigs, name, PNCounterConfig.class);
    }

    public Config addExecutorConfig(ExecutorConfig executorConfig) {
        this.executorConfigs.put(executorConfig.getName(), executorConfig);
        return this;
    }

    public Config addDurableExecutorConfig(DurableExecutorConfig durableExecutorConfig) {
        this.durableExecutorConfigs.put(durableExecutorConfig.getName(), durableExecutorConfig);
        return this;
    }

    public Config addScheduledExecutorConfig(ScheduledExecutorConfig scheduledExecutorConfig) {
        this.scheduledExecutorConfigs.put(scheduledExecutorConfig.getName(), scheduledExecutorConfig);
        return this;
    }

    public Config addCardinalityEstimatorConfig(CardinalityEstimatorConfig cardinalityEstimatorConfig) {
        this.cardinalityEstimatorConfigs.put(cardinalityEstimatorConfig.getName(), cardinalityEstimatorConfig);
        return this;
    }

    public Config addPNCounterConfig(PNCounterConfig pnCounterConfig) {
        this.pnCounterConfigs.put(pnCounterConfig.getName(), pnCounterConfig);
        return this;
    }

    public Map<String, ExecutorConfig> getExecutorConfigs() {
        return this.executorConfigs;
    }

    public Config setExecutorConfigs(Map<String, ExecutorConfig> executorConfigs) {
        this.executorConfigs.clear();
        this.executorConfigs.putAll(executorConfigs);
        for (Map.Entry<String, ExecutorConfig> entry : executorConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public Map<String, DurableExecutorConfig> getDurableExecutorConfigs() {
        return this.durableExecutorConfigs;
    }

    public Config setDurableExecutorConfigs(Map<String, DurableExecutorConfig> durableExecutorConfigs) {
        this.durableExecutorConfigs.clear();
        this.durableExecutorConfigs.putAll(durableExecutorConfigs);
        for (Map.Entry<String, DurableExecutorConfig> entry : durableExecutorConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public Map<String, ScheduledExecutorConfig> getScheduledExecutorConfigs() {
        return this.scheduledExecutorConfigs;
    }

    public Config setScheduledExecutorConfigs(Map<String, ScheduledExecutorConfig> scheduledExecutorConfigs) {
        this.scheduledExecutorConfigs.clear();
        this.scheduledExecutorConfigs.putAll(scheduledExecutorConfigs);
        for (Map.Entry<String, ScheduledExecutorConfig> entry : scheduledExecutorConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public Map<String, CardinalityEstimatorConfig> getCardinalityEstimatorConfigs() {
        return this.cardinalityEstimatorConfigs;
    }

    public Config setCardinalityEstimatorConfigs(Map<String, CardinalityEstimatorConfig> cardinalityEstimatorConfigs) {
        this.cardinalityEstimatorConfigs.clear();
        this.cardinalityEstimatorConfigs.putAll(cardinalityEstimatorConfigs);
        for (Map.Entry<String, CardinalityEstimatorConfig> entry : cardinalityEstimatorConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public Map<String, PNCounterConfig> getPNCounterConfigs() {
        return this.pnCounterConfigs;
    }

    public Config setPNCounterConfigs(Map<String, PNCounterConfig> pnCounterConfigs) {
        this.pnCounterConfigs.clear();
        this.pnCounterConfigs.putAll(pnCounterConfigs);
        for (Map.Entry<String, PNCounterConfig> entry : pnCounterConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public WanReplicationConfig getWanReplicationConfig(String name) {
        return this.wanReplicationConfigs.get(name);
    }

    public Config addWanReplicationConfig(WanReplicationConfig wanReplicationConfig) {
        this.wanReplicationConfigs.put(wanReplicationConfig.getName(), wanReplicationConfig);
        return this;
    }

    public Map<String, WanReplicationConfig> getWanReplicationConfigs() {
        return this.wanReplicationConfigs;
    }

    public Config setWanReplicationConfigs(Map<String, WanReplicationConfig> wanReplicationConfigs) {
        this.wanReplicationConfigs.clear();
        this.wanReplicationConfigs.putAll(wanReplicationConfigs);
        for (Map.Entry<String, WanReplicationConfig> entry : this.wanReplicationConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public Map<String, SplitBrainProtectionConfig> getSplitBrainProtectionConfigs() {
        return this.splitBrainProtectionConfigs;
    }

    public SplitBrainProtectionConfig getSplitBrainProtectionConfig(String name) {
        return ConfigUtils.getConfig(this.configPatternMatcher, this.splitBrainProtectionConfigs, name, SplitBrainProtectionConfig.class);
    }

    public SplitBrainProtectionConfig findSplitBrainProtectionConfig(String name) {
        SplitBrainProtectionConfig config = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.splitBrainProtectionConfigs, name = StringPartitioningStrategy.getBaseName(name));
        if (config != null) {
            return config;
        }
        return this.getSplitBrainProtectionConfig("default");
    }

    public Config setSplitBrainProtectionConfigs(Map<String, SplitBrainProtectionConfig> splitBrainProtectionConfigs) {
        this.splitBrainProtectionConfigs.clear();
        this.splitBrainProtectionConfigs.putAll(splitBrainProtectionConfigs);
        for (Map.Entry<String, SplitBrainProtectionConfig> entry : this.splitBrainProtectionConfigs.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public Config addSplitBrainProtectionConfig(SplitBrainProtectionConfig splitBrainProtectionConfig) {
        this.splitBrainProtectionConfigs.put(splitBrainProtectionConfig.getName(), splitBrainProtectionConfig);
        return this;
    }

    public ManagementCenterConfig getManagementCenterConfig() {
        return this.managementCenterConfig;
    }

    public Config setManagementCenterConfig(ManagementCenterConfig managementCenterConfig) {
        this.managementCenterConfig = managementCenterConfig;
        return this;
    }

    public SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public Config setSecurityConfig(SecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
        return this;
    }

    public Config addListenerConfig(ListenerConfig listenerConfig) {
        this.getListenerConfigs().add(listenerConfig);
        return this;
    }

    public List<ListenerConfig> getListenerConfigs() {
        return this.listenerConfigs;
    }

    public Config setListenerConfigs(List<ListenerConfig> listenerConfigs) {
        this.listenerConfigs.clear();
        this.listenerConfigs.addAll(listenerConfigs);
        return this;
    }

    public Map<String, FlakeIdGeneratorConfig> getFlakeIdGeneratorConfigs() {
        return this.flakeIdGeneratorConfigMap;
    }

    public FlakeIdGeneratorConfig findFlakeIdGeneratorConfig(String name) {
        String baseName = StringPartitioningStrategy.getBaseName(name);
        FlakeIdGeneratorConfig config = ConfigUtils.lookupByPattern(this.configPatternMatcher, this.flakeIdGeneratorConfigMap, baseName);
        if (config != null) {
            return config;
        }
        return this.getFlakeIdGeneratorConfig("default");
    }

    public FlakeIdGeneratorConfig getFlakeIdGeneratorConfig(String name) {
        return ConfigUtils.getConfig(this.configPatternMatcher, this.flakeIdGeneratorConfigMap, name, FlakeIdGeneratorConfig.class, FlakeIdGeneratorConfig::setName);
    }

    public Config addFlakeIdGeneratorConfig(FlakeIdGeneratorConfig config) {
        this.flakeIdGeneratorConfigMap.put(config.getName(), config);
        return this;
    }

    public Config setFlakeIdGeneratorConfigs(Map<String, FlakeIdGeneratorConfig> map) {
        this.flakeIdGeneratorConfigMap.clear();
        this.flakeIdGeneratorConfigMap.putAll(map);
        for (Map.Entry<String, FlakeIdGeneratorConfig> entry : map.entrySet()) {
            entry.getValue().setName(entry.getKey());
        }
        return this;
    }

    public SerializationConfig getSerializationConfig() {
        return this.serializationConfig;
    }

    public Config setSerializationConfig(SerializationConfig serializationConfig) {
        this.serializationConfig = serializationConfig;
        return this;
    }

    public PartitionGroupConfig getPartitionGroupConfig() {
        return this.partitionGroupConfig;
    }

    public Config setPartitionGroupConfig(PartitionGroupConfig partitionGroupConfig) {
        this.partitionGroupConfig = partitionGroupConfig;
        return this;
    }

    public HotRestartPersistenceConfig getHotRestartPersistenceConfig() {
        return this.hotRestartPersistenceConfig;
    }

    public Config setHotRestartPersistenceConfig(HotRestartPersistenceConfig hrConfig) {
        Preconditions.checkNotNull(hrConfig, "Hot restart config cannot be null!");
        this.hotRestartPersistenceConfig = hrConfig;
        return this;
    }

    public CRDTReplicationConfig getCRDTReplicationConfig() {
        return this.crdtReplicationConfig;
    }

    public Config setCRDTReplicationConfig(CRDTReplicationConfig crdtReplicationConfig) {
        Preconditions.checkNotNull(crdtReplicationConfig, "The CRDT replication config cannot be null!");
        this.crdtReplicationConfig = crdtReplicationConfig;
        return this;
    }

    public ManagedContext getManagedContext() {
        return this.managedContext;
    }

    public Config setManagedContext(ManagedContext managedContext) {
        this.managedContext = managedContext;
        return this;
    }

    public ConcurrentMap<String, Object> getUserContext() {
        return this.userContext;
    }

    public Config setUserContext(ConcurrentMap<String, Object> userContext) {
        if (userContext == null) {
            throw new IllegalArgumentException("userContext can't be null");
        }
        this.userContext = userContext;
        return this;
    }

    public NativeMemoryConfig getNativeMemoryConfig() {
        return this.nativeMemoryConfig;
    }

    public Config setNativeMemoryConfig(NativeMemoryConfig nativeMemoryConfig) {
        this.nativeMemoryConfig = nativeMemoryConfig;
        return this;
    }

    public URL getConfigurationUrl() {
        return this.configurationUrl;
    }

    public Config setConfigurationUrl(URL configurationUrl) {
        this.configurationUrl = configurationUrl;
        return this;
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }

    public Config setConfigurationFile(File configurationFile) {
        this.configurationFile = configurationFile;
        return this;
    }

    public String getLicenseKey() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new HazelcastRuntimePermission("com.hazelcast.config.Config.getLicenseKey"));
        }
        return this.licenseKey;
    }

    public Config setLicenseKey(String licenseKey) {
        this.licenseKey = licenseKey;
        return this;
    }

    public boolean isLiteMember() {
        return this.liteMember;
    }

    public Config setLiteMember(boolean liteMember) {
        this.liteMember = liteMember;
        return this;
    }

    public UserCodeDeploymentConfig getUserCodeDeploymentConfig() {
        return this.userCodeDeploymentConfig;
    }

    public Config setUserCodeDeploymentConfig(UserCodeDeploymentConfig userCodeDeploymentConfig) {
        this.userCodeDeploymentConfig = userCodeDeploymentConfig;
        return this;
    }

    public AdvancedNetworkConfig getAdvancedNetworkConfig() {
        return this.advancedNetworkConfig;
    }

    public Config setAdvancedNetworkConfig(AdvancedNetworkConfig advancedNetworkConfig) {
        this.advancedNetworkConfig = advancedNetworkConfig;
        return this;
    }

    public CPSubsystemConfig getCPSubsystemConfig() {
        return this.cpSubsystemConfig;
    }

    public Config setCPSubsystemConfig(CPSubsystemConfig cpSubsystemConfig) {
        this.cpSubsystemConfig = cpSubsystemConfig;
        return this;
    }

    @Nonnull
    public MetricsConfig getMetricsConfig() {
        return this.metricsConfig;
    }

    @Nonnull
    public Config setMetricsConfig(@Nonnull MetricsConfig metricsConfig) {
        Preconditions.checkNotNull(metricsConfig, "metricsConfig");
        this.metricsConfig = metricsConfig;
        return this;
    }

    @Nonnull
    public AuditlogConfig getAuditlogConfig() {
        return this.auditlogConfig;
    }

    @Nonnull
    public Config setAuditlogConfig(@Nonnull AuditlogConfig auditlogConfig) {
        this.auditlogConfig = Preconditions.checkNotNull(auditlogConfig, "auditlogConfig");
        return this;
    }

    @Nonnull
    public SqlConfig getSqlConfig() {
        return this.sqlConfig;
    }

    @Nonnull
    public Config setSqlConfig(@Nonnull SqlConfig sqlConfig) {
        Preconditions.checkNotNull(sqlConfig, "sqlConfig");
        this.sqlConfig = sqlConfig;
        return this;
    }

    @Nonnull
    public InstanceTrackingConfig getInstanceTrackingConfig() {
        return this.instanceTrackingConfig;
    }

    @Nonnull
    public Config setInstanceTrackingConfig(@Nonnull InstanceTrackingConfig instanceTrackingConfig) {
        Preconditions.checkNotNull(instanceTrackingConfig, "instanceTrackingConfig");
        this.instanceTrackingConfig = instanceTrackingConfig;
        return this;
    }

    @PrivateApi
    protected ServicesConfig getServicesConfig() {
        return this.servicesConfig;
    }

    public String toString() {
        return "Config{configurationUrl=" + this.configurationUrl + ", configurationFile=" + this.configurationFile + ", classLoader=" + this.classLoader + ", properties=" + this.properties + ", instanceName='" + this.instanceName + '\'' + ", clusterName='" + this.clusterName + '\'' + ", networkConfig=" + this.networkConfig + ", configPatternMatcher=" + this.configPatternMatcher + ", mapConfigs=" + this.mapConfigs + ", cacheConfigs=" + this.cacheConfigs + ", topicConfigs=" + this.topicConfigs + ", reliableTopicConfigs=" + this.reliableTopicConfigs + ", queueConfigs=" + this.queueConfigs + ", multiMapConfigs=" + this.multiMapConfigs + ", listConfigs=" + this.listConfigs + ", setConfigs=" + this.setConfigs + ", executorConfigs=" + this.executorConfigs + ", durableExecutorConfigs=" + this.durableExecutorConfigs + ", scheduledExecutorConfigs=" + this.scheduledExecutorConfigs + ", replicatedMapConfigs=" + this.replicatedMapConfigs + ", wanReplicationConfigs=" + this.wanReplicationConfigs + ", splitBrainProtectionConfigs=" + this.splitBrainProtectionConfigs + ", ringbufferConfigs=" + this.ringbufferConfigs + ", cardinalityEstimatorConfigs=" + this.cardinalityEstimatorConfigs + ", flakeIdGeneratorConfigMap=" + this.flakeIdGeneratorConfigMap + ", pnCounterConfigs=" + this.pnCounterConfigs + ", advancedNetworkConfig=" + this.advancedNetworkConfig + ", servicesConfig=" + this.servicesConfig + ", securityConfig=" + this.securityConfig + ", listenerConfigs=" + this.listenerConfigs + ", partitionGroupConfig=" + this.partitionGroupConfig + ", managementCenterConfig=" + this.managementCenterConfig + ", serializationConfig=" + this.serializationConfig + ", managedContext=" + this.managedContext + ", userContext=" + this.userContext + ", memberAttributeConfig=" + this.memberAttributeConfig + ", nativeMemoryConfig=" + this.nativeMemoryConfig + ", hotRestartPersistenceConfig=" + this.hotRestartPersistenceConfig + ", userCodeDeploymentConfig=" + this.userCodeDeploymentConfig + ", crdtReplicationConfig=" + this.crdtReplicationConfig + ", liteMember=" + this.liteMember + ", cpSubsystemConfig=" + this.cpSubsystemConfig + ", sqlConfig=" + this.sqlConfig + ", metricsConfig=" + this.metricsConfig + ", auditlogConfig=" + this.auditlogConfig + '}';
    }
}

