/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractAsyncMessageTask;
import com.hazelcast.cluster.Member;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.spi.impl.operationservice.InvocationBuilder;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.impl.InvocationFuture;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;

public abstract class AbstractMultiTargetMessageTask<P>
extends AbstractAsyncMessageTask<P, Object> {
    protected AbstractMultiTargetMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected CompletableFuture<Object> processInternal() {
        Supplier<Operation> operationSupplier = this.createOperationSupplier();
        Collection<Member> targets = this.getTargets();
        CompletableFuture<Object> finalResult = new CompletableFuture<Object>();
        if (targets.isEmpty()) {
            finalResult.complete(Collections.EMPTY_MAP);
            return finalResult;
        }
        OperationServiceImpl operationService = this.nodeEngine.getOperationService();
        MultiTargetCallback callback = new MultiTargetCallback(targets, finalResult);
        for (Member target : targets) {
            Operation op = operationSupplier.get();
            op.setCallerUuid(this.endpoint.getUuid());
            InvocationBuilder builder = operationService.createInvocationBuilder(this.getServiceName(), op, target.getAddress()).setResultDeserialized(false);
            InvocationFuture invocationFuture = builder.invoke();
            invocationFuture.whenCompleteAsync((BiConsumer)new SingleTargetCallback(target, callback), ConcurrencyUtil.CALLER_RUNS);
        }
        return finalResult;
    }

    protected abstract Supplier<Operation> createOperationSupplier();

    protected abstract Object reduce(Map<Member, Object> var1) throws Throwable;

    public abstract Collection<Member> getTargets();

    private final class SingleTargetCallback
    implements BiConsumer<Object, Throwable> {
        final Member target;
        final MultiTargetCallback parent;

        private SingleTargetCallback(Member target, MultiTargetCallback parent) {
            this.target = target;
            this.parent = parent;
        }

        @Override
        public void accept(Object object, Throwable throwable) {
            this.parent.notify(this.target, throwable == null ? object : throwable);
        }
    }

    private final class MultiTargetCallback {
        final Collection<Member> targets;
        final Map<Member, Object> results;
        final CompletableFuture<Object> finalResult;

        private MultiTargetCallback(Collection<Member> targets, CompletableFuture<Object> finalResult) {
            this.targets = new HashSet<Member>(targets);
            this.results = MapUtil.createHashMap(targets.size());
            this.finalResult = finalResult;
        }

        public synchronized void notify(Member target, Object result) {
            if (this.targets.remove(target)) {
                this.results.put(target, result);
            } else {
                if (this.results.containsKey(target)) {
                    this.finalResult.completeExceptionally(new IllegalArgumentException("Duplicate response from -> " + target));
                }
                this.finalResult.completeExceptionally(new IllegalArgumentException("Unknown target! -> " + target));
            }
            if (this.targets.isEmpty()) {
                try {
                    this.finalResult.complete(AbstractMultiTargetMessageTask.this.reduce(this.results));
                }
                catch (Throwable throwable) {
                    this.finalResult.completeExceptionally(throwable);
                }
            }
        }
    }
}

