/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web.entryprocessor;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.web.SessionState;
import com.hazelcast.web.WebDataSerializerHook;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class SessionUpdateEntryProcessor
implements EntryProcessor<String, SessionState, Object>,
IdentifiedDataSerializable {
    private Map<String, Data> attributes;

    public SessionUpdateEntryProcessor(int size) {
        this.attributes = new HashMap<String, Data>(size);
    }

    public SessionUpdateEntryProcessor(String key, Data value) {
        this.attributes = new HashMap<String, Data>(1);
        this.attributes.put(key, value);
    }

    public SessionUpdateEntryProcessor() {
        this.attributes = Collections.emptyMap();
    }

    public Map<String, Data> getAttributes() {
        return this.attributes;
    }

    @Override
    public int getFactoryId() {
        return WebDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public Object process(Map.Entry<String, SessionState> entry) {
        SessionState sessionState = entry.getValue();
        if (sessionState == null) {
            sessionState = new SessionState();
        }
        for (Map.Entry<String, Data> attribute : this.attributes.entrySet()) {
            String name = attribute.getKey();
            Data value = attribute.getValue();
            if (value == null) {
                sessionState.getAttributes().remove(name);
                continue;
            }
            sessionState.getAttributes().put(name, value);
        }
        entry.setValue(sessionState);
        return Boolean.TRUE;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.attributes.size());
        for (Map.Entry<String, Data> entry : this.attributes.entrySet()) {
            out.writeUTF(entry.getKey());
            IOUtil.writeData(out, entry.getValue());
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        int attCount = in.readInt();
        this.attributes = new HashMap<String, Data>(attCount);
        for (int i = 0; i < attCount; ++i) {
            this.attributes.put(in.readUTF(), IOUtil.readData(in));
        }
    }
}

