/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.worker;

import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.sql.impl.LocalMemberIdProvider;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.operation.QueryOperationHandler;
import com.hazelcast.sql.impl.worker.QueryOperationExecutable;
import com.hazelcast.sql.impl.worker.QueryPoolTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicLong;

public class QueryOperationWorkerPool {
    private final LocalMemberIdProvider localMemberIdProvider;
    private final QueryOperationHandler operationHandler;
    private final SerializationService serializationService;
    private final ILogger logger;
    private final ExecutorService exec;

    public QueryOperationWorkerPool(String instanceName, String workerName, int threadCount, LocalMemberIdProvider localMemberIdProvider, QueryOperationHandler operationHandler, SerializationService serializationService, ILogger logger, boolean system) {
        this.localMemberIdProvider = localMemberIdProvider;
        this.operationHandler = operationHandler;
        this.serializationService = serializationService;
        this.logger = logger;
        WorkerThreadFactory threadFactory = new WorkerThreadFactory(instanceName, workerName, system);
        this.exec = new ForkJoinPool(threadCount, threadFactory, new ExceptionHandler(), true);
    }

    public void submit(QueryOperationExecutable task) {
        this.exec.submit(new QueryPoolTask(task, this.localMemberIdProvider, this.operationHandler, this.serializationService, this.logger));
    }

    public void stop() {
        this.exec.shutdownNow();
    }

    public static boolean isSystemThread() {
        Thread thread = Thread.currentThread();
        return thread instanceof WorkerThread && ((WorkerThread)thread).isSystem();
    }

    private class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private ExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable t) {
            OutOfMemoryErrorDispatcher.inspectOutOfMemoryError(t);
            QueryOperationWorkerPool.this.logger.severe(t);
        }
    }

    private static final class WorkerThreadFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        private final AtomicLong counter = new AtomicLong();
        private final String instanceName;
        private final String workerName;
        private final boolean system;

        private WorkerThreadFactory(String instanceName, String workerName, boolean system) {
            this.instanceName = instanceName;
            this.workerName = workerName;
            this.system = system;
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            String name = QueryUtils.workerName(this.instanceName, this.workerName, this.counter.incrementAndGet());
            WorkerThread thread = new WorkerThread(pool, this.system);
            thread.setName(name);
            return thread;
        }
    }

    private static final class WorkerThread
    extends ForkJoinWorkerThread {
        private final boolean system;

        private WorkerThread(ForkJoinPool pool, boolean system) {
            super(pool);
            this.system = system;
        }

        private boolean isSystem() {
            return this.system;
        }
    }
}

