/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.math;

import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;

public final class MathFunctionUtils {
    private MathFunctionUtils() {
    }

    public static boolean notFractional(QueryDataType type) {
        switch (type.getTypeFamily()) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                return true;
            }
        }
        return false;
    }

    public static Integer asInt(Expression<?> expression, Row row, ExpressionEvalContext context) {
        Object res = expression.eval(row, context);
        if (res == null) {
            return null;
        }
        return expression.getType().getConverter().asInt(res);
    }

    public static Long asBigint(Expression<?> expression, Row row, ExpressionEvalContext context) {
        Object res = expression.eval(row, context);
        if (res == null) {
            return null;
        }
        return expression.getType().getConverter().asBigint(res);
    }
}

