/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.io.flowcontrol.simple;

import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryId;
import com.hazelcast.sql.impl.exec.io.flowcontrol.FlowControl;
import com.hazelcast.sql.impl.exec.io.flowcontrol.simple.SimpleFlowControlStream;
import com.hazelcast.sql.impl.operation.QueryFlowControlExchangeOperation;
import com.hazelcast.sql.impl.operation.QueryOperationHandler;
import java.util.HashMap;
import java.util.UUID;

public class SimpleFlowControl
implements FlowControl {
    static final double THRESHOLD_PERCENTAGE = 0.25;
    private final long maxMemory;
    private final double thresholdPercentage;
    private QueryId queryId;
    private int edgeId;
    private UUID localMemberId;
    private QueryOperationHandler operationHandler;
    private HashMap<UUID, SimpleFlowControlStream> streams;
    private HashMap<UUID, SimpleFlowControlStream> pendingStreams;
    private long ordinal;

    public SimpleFlowControl(long maxMemory, double thresholdPercentage) {
        this.maxMemory = maxMemory;
        this.thresholdPercentage = thresholdPercentage;
    }

    @Override
    public void setup(QueryId queryId, int edgeId, UUID localMemberId, QueryOperationHandler operationHandler) {
        this.queryId = queryId;
        this.edgeId = edgeId;
        this.localMemberId = localMemberId;
        this.operationHandler = operationHandler;
    }

    @Override
    public void onBatchAdded(UUID memberId, long size, boolean last, long remoteMemory) {
        if (last) {
            if (this.streams != null) {
                this.streams.remove(memberId);
            }
            if (this.pendingStreams != null) {
                this.pendingStreams.remove(memberId);
            }
            return;
        }
        if (this.streams == null) {
            this.streams = new HashMap();
            this.streams.put(memberId, new SimpleFlowControlStream(memberId, remoteMemory, this.maxMemory - size));
        } else {
            SimpleFlowControlStream state = this.streams.get(memberId);
            if (state != null) {
                state.updateMemory(remoteMemory, state.getLocalMemory() - size);
            } else {
                this.streams.put(memberId, new SimpleFlowControlStream(memberId, remoteMemory, this.maxMemory - size));
            }
        }
    }

    @Override
    public void onBatchRemoved(UUID memberId, long size, boolean last) {
        if (last) {
            return;
        }
        assert (this.streams != null);
        SimpleFlowControlStream state = this.streams.get(memberId);
        if (state == null) {
            return;
        }
        long remoteMemory = state.getRemoteMemory();
        long localMemory = state.getLocalMemory() + size;
        state.updateMemory(remoteMemory, localMemory);
        if (this.isLowMemory(remoteMemory) && !this.isLowMemory(localMemory) && !state.isShouldSend()) {
            state.setShouldSend(true);
            if (this.pendingStreams == null) {
                this.pendingStreams = new HashMap();
            }
            this.pendingStreams.put(memberId, state);
        }
    }

    @Override
    public void onFragmentExecutionCompleted() {
        if (this.pendingStreams == null || this.pendingStreams.isEmpty()) {
            return;
        }
        for (SimpleFlowControlStream stream : this.pendingStreams.values()) {
            this.sendFlowControl(stream);
            stream.setShouldSend(false);
        }
        this.pendingStreams.clear();
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    public double getThresholdPercentage() {
        return this.thresholdPercentage;
    }

    private void sendFlowControl(SimpleFlowControlStream stream) {
        QueryFlowControlExchangeOperation operation = new QueryFlowControlExchangeOperation(this.queryId, this.edgeId, stream.getMemberId(), this.ordinal++, stream.getLocalMemory());
        boolean success = this.operationHandler.submit(this.localMemberId, stream.getMemberId(), operation);
        if (!success) {
            throw QueryException.memberConnection(stream.getMemberId());
        }
    }

    private boolean isLowMemory(long availableMemory) {
        return (double)availableMemory / (double)this.maxMemory <= this.thresholdPercentage;
    }
}

