/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.io;

import com.hazelcast.sql.impl.exec.AbstractExec;
import com.hazelcast.sql.impl.exec.IterationResult;
import com.hazelcast.sql.impl.exec.io.InboundBatch;
import com.hazelcast.sql.impl.exec.io.Inbox;
import com.hazelcast.sql.impl.row.RowBatch;
import com.hazelcast.sql.impl.worker.QueryFragmentContext;

public class ReceiveExec
extends AbstractExec {
    private final Inbox inbox;
    private RowBatch curBatch;

    public ReceiveExec(int id, Inbox inbox) {
        super(id);
        this.inbox = inbox;
    }

    @Override
    protected void setup0(QueryFragmentContext ctx) {
        this.inbox.setup();
    }

    @Override
    public IterationResult advance0() {
        InboundBatch batch = this.inbox.poll();
        if (batch == null) {
            this.curBatch = null;
            return IterationResult.WAIT;
        }
        this.curBatch = batch.getBatch();
        return this.inbox.closed() ? IterationResult.FETCHED_DONE : IterationResult.FETCHED;
    }

    @Override
    public RowBatch currentBatch0() {
        return this.curBatch;
    }

    public Inbox getInbox() {
        return this.inbox;
    }
}

