/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.operators.string;

import com.hazelcast.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlOperandCountRange;
import com.hazelcast.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.org.apache.calcite.sql.type.SqlOperandCountRanges;
import com.hazelcast.org.apache.calcite.sql.type.SqlReturnTypeInference;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.calcite.validate.HazelcastCallBinding;
import com.hazelcast.sql.impl.calcite.validate.operand.TypedOperandChecker;
import com.hazelcast.sql.impl.calcite.validate.operators.ReplaceUnknownOperandTypeInference;
import com.hazelcast.sql.impl.calcite.validate.operators.common.HazelcastFunction;

public final class HazelcastStringFunction
extends HazelcastFunction {
    public static final SqlFunction ASCII = HazelcastStringFunction.withIntegerReturn("ASCII");
    public static final SqlFunction INITCAP = HazelcastStringFunction.withStringReturn("INITCAP");
    public static final SqlFunction CHAR_LENGTH = HazelcastStringFunction.withIntegerReturn("CHAR_LENGTH");
    public static final SqlFunction CHARACTER_LENGTH = HazelcastStringFunction.withIntegerReturn("CHARACTER_LENGTH");
    public static final SqlFunction LENGTH = HazelcastStringFunction.withIntegerReturn("LENGTH");
    public static final SqlFunction LOWER = HazelcastStringFunction.withStringReturn("LOWER");
    public static final SqlFunction UPPER = HazelcastStringFunction.withStringReturn("UPPER");
    public static final SqlFunction RTRIM = HazelcastStringFunction.withStringReturn("RTRIM");
    public static final SqlFunction LTRIM = HazelcastStringFunction.withStringReturn("LTRIM");
    public static final SqlFunction BTRIM = HazelcastStringFunction.withStringReturn("BTRIM");

    private HazelcastStringFunction(String name, SqlReturnTypeInference returnTypeInference) {
        super(name, SqlKind.OTHER_FUNCTION, returnTypeInference, new ReplaceUnknownOperandTypeInference(SqlTypeName.VARCHAR), SqlFunctionCategory.STRING);
    }

    @Override
    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of(1);
    }

    @Override
    public boolean checkOperandTypes(HazelcastCallBinding callBinding, boolean throwOnFailure) {
        return TypedOperandChecker.VARCHAR.check(callBinding, throwOnFailure, 0);
    }

    private static HazelcastStringFunction withStringReturn(String name) {
        return new HazelcastStringFunction(name, ReturnTypes.ARG0_NULLABLE);
    }

    private static HazelcastStringFunction withIntegerReturn(String name) {
        return new HazelcastStringFunction(name, ReturnTypes.INTEGER_NULLABLE);
    }
}

