/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.opt;

import com.hazelcast.org.apache.calcite.plan.Convention;
import com.hazelcast.org.apache.calcite.plan.ConventionTraitDef;
import com.hazelcast.org.apache.calcite.plan.HazelcastRelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.plan.RelTrait;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.plan.volcano.HazelcastRelSubsetUtil;
import com.hazelcast.org.apache.calcite.prepare.RelOptTableImpl;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalTableScan;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.sql.impl.calcite.opt.HazelcastConventions;
import com.hazelcast.sql.impl.calcite.opt.distribution.DistributionTrait;
import com.hazelcast.sql.impl.calcite.opt.distribution.DistributionTraitDef;
import com.hazelcast.sql.impl.calcite.schema.HazelcastRelOptTable;
import com.hazelcast.sql.impl.calcite.schema.HazelcastTable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;

public final class OptUtils {
    private OptUtils() {
    }

    public static <R extends RelNode> RelOptRuleOperand single(Class<R> cls, Convention convention) {
        return RelOptRule.operand(cls, convention, RelOptRule.any());
    }

    public static <R1 extends RelNode, R2 extends RelNode> RelOptRuleOperand parentChild(Class<R1> cls, Class<R2> childCls, Convention convention) {
        RelOptRuleOperand childOperand = RelOptRule.operand(childCls, RelOptRule.any());
        return RelOptRule.operand(cls, convention, RelOptRule.some(childOperand, new RelOptRuleOperand[0]));
    }

    public static RelTraitSet traitPlus(RelTraitSet traitSet, RelTrait trait) {
        return traitSet.plus(trait).simplify();
    }

    public static RelTraitSet traitPlus(RelTraitSet traitSet, RelTrait trait1, RelTrait trait2) {
        return traitSet.plus(trait1).plus(trait2).simplify();
    }

    public static RelTraitSet toLogicalConvention(RelTraitSet traitSet) {
        return OptUtils.traitPlus(traitSet, HazelcastConventions.LOGICAL);
    }

    public static RelNode toLogicalInput(RelNode input) {
        return RelOptRule.convert(input, OptUtils.toLogicalConvention(input.getTraitSet()));
    }

    public static RelTraitSet toPhysicalConvention(RelTraitSet traitSet) {
        return OptUtils.traitPlus(traitSet, HazelcastConventions.PHYSICAL);
    }

    public static RelTraitSet toPhysicalConvention(RelTraitSet traitSet, DistributionTrait distribution) {
        return OptUtils.traitPlus(traitSet, HazelcastConventions.PHYSICAL, distribution);
    }

    public static RelNode toPhysicalInput(RelNode input) {
        return RelOptRule.convert(input, OptUtils.toPhysicalConvention(input.getTraitSet()));
    }

    public static RelNode toPhysicalInput(RelNode input, DistributionTrait distribution) {
        return RelOptRule.convert(input, OptUtils.toPhysicalConvention(input.getTraitSet(), distribution));
    }

    public static boolean isPhysical(RelNode rel) {
        return rel.getTraitSet().getTrait(ConventionTraitDef.INSTANCE).equals(HazelcastConventions.PHYSICAL);
    }

    public static Collection<RelNode> getPhysicalRelsFromSubset(RelNode input) {
        HashSet<RelTraitSet> traitSets = new HashSet<RelTraitSet>();
        Set<RelNode> res = Collections.newSetFromMap(new IdentityHashMap());
        for (RelNode relNode : HazelcastRelSubsetUtil.getSubsets(input)) {
            if (!OptUtils.isPhysical(relNode) || !traitSets.add(relNode.getTraitSet())) continue;
            res.add(relNode);
        }
        return res;
    }

    public static boolean isHazelcastTable(TableScan scan) {
        HazelcastTable table = scan.getTable().unwrap(HazelcastTable.class);
        return table != null;
    }

    public static HazelcastTable getHazelcastTable(TableScan scan) {
        HazelcastTable table = scan.getTable().unwrap(HazelcastTable.class);
        assert (table != null);
        return table;
    }

    public static HazelcastRelOptCluster getCluster(RelNode rel) {
        assert (rel.getCluster() instanceof HazelcastRelOptCluster);
        return (HazelcastRelOptCluster)rel.getCluster();
    }

    public static DistributionTraitDef getDistributionDef(RelNode rel) {
        return OptUtils.getCluster(rel).getDistributionTraitDef();
    }

    public static DistributionTrait getDistribution(RelNode rel) {
        return rel.getTraitSet().getTrait(OptUtils.getDistributionDef(rel));
    }

    public static HazelcastRelOptTable createRelTable(HazelcastRelOptTable originalRelTable, HazelcastTable newHazelcastTable, RelDataTypeFactory typeFactory) {
        RelOptTableImpl newTable = RelOptTableImpl.create(originalRelTable.getRelOptSchema(), newHazelcastTable.getRowType(typeFactory), originalRelTable.getDelegate().getQualifiedName(), newHazelcastTable, null);
        return new HazelcastRelOptTable(newTable);
    }

    public static LogicalTableScan createLogicalScanWithNewTable(TableScan originalScan, HazelcastTable newHazelcastTable) {
        HazelcastRelOptTable originalRelTable = (HazelcastRelOptTable)originalScan.getTable();
        HazelcastRelOptTable newTable = OptUtils.createRelTable(originalRelTable, newHazelcastTable, originalScan.getCluster().getTypeFactory());
        return LogicalTableScan.create(originalScan.getCluster(), newTable, originalScan.getHints());
    }
}

