/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.internal.config.ConfigValidator;
import com.hazelcast.internal.partition.FragmentedMigrationAwareService;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.partition.MigrationEndpoint;
import com.hazelcast.internal.partition.PartitionMigrationEvent;
import com.hazelcast.internal.partition.PartitionReplicationEvent;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.services.DistributedObjectNamespace;
import com.hazelcast.internal.services.ManagedService;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.services.RemoteService;
import com.hazelcast.internal.services.ServiceNamespace;
import com.hazelcast.internal.services.SplitBrainHandlerService;
import com.hazelcast.internal.services.SplitBrainProtectionAwareService;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.internal.util.ContextMutexFactory;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.ringbuffer.impl.RingbufferContainer;
import com.hazelcast.ringbuffer.impl.RingbufferContainerCollector;
import com.hazelcast.ringbuffer.impl.RingbufferProxy;
import com.hazelcast.ringbuffer.impl.operations.MergeOperation;
import com.hazelcast.ringbuffer.impl.operations.ReplicationOperation;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.merge.AbstractContainerMerger;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.merge.RingbufferMergeData;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionOn;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RingbufferService
implements ManagedService,
RemoteService,
FragmentedMigrationAwareService,
SplitBrainProtectionAwareService,
SplitBrainHandlerService {
    public static final String TOPIC_RB_PREFIX = "_hz_rb_";
    public static final String SERVICE_NAME = "hz:impl:ringbufferService";
    private static final Object NULL_OBJECT = new Object();
    private final ConcurrentMap<Integer, Map<ObjectNamespace, RingbufferContainer>> containers = new ConcurrentHashMap<Integer, Map<ObjectNamespace, RingbufferContainer>>();
    private final ConcurrentMap<String, Object> splitBrainProtectionConfigCache = new ConcurrentHashMap<String, Object>();
    private final ContextMutexFactory splitBrainProtectionConfigCacheMutexFactory = new ContextMutexFactory();
    private final ConstructorFunction<String, Object> splitBrainProtectionConfigConstructor = new ConstructorFunction<String, Object>(){

        @Override
        public Object createNew(String name) {
            RingbufferConfig config = RingbufferService.this.nodeEngine.getConfig().findRingbufferConfig(name);
            String splitBrainProtectionName = config.getSplitBrainProtectionName();
            return splitBrainProtectionName == null ? NULL_OBJECT : splitBrainProtectionName;
        }
    };
    private NodeEngine nodeEngine;
    private SerializationService serializationService;
    private IPartitionService partitionService;
    private SplitBrainProtectionService splitBrainProtectionService;

    public RingbufferService(NodeEngineImpl nodeEngine) {
        this.init(nodeEngine, null);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        this.nodeEngine = Preconditions.checkNotNull(nodeEngine, "nodeEngine can't be null");
        this.serializationService = nodeEngine.getSerializationService();
        this.partitionService = nodeEngine.getPartitionService();
        this.splitBrainProtectionService = nodeEngine.getSplitBrainProtectionService();
    }

    public ConcurrentMap<Integer, Map<ObjectNamespace, RingbufferContainer>> getContainers() {
        return this.containers;
    }

    @Override
    public DistributedObject createDistributedObject(String objectName, UUID source, boolean local) {
        RingbufferConfig ringbufferConfig = this.getRingbufferConfig(objectName);
        ConfigValidator.checkRingbufferConfig(ringbufferConfig, this.nodeEngine.getSplitBrainMergePolicyProvider());
        return new RingbufferProxy(this.nodeEngine, this, objectName, ringbufferConfig);
    }

    @Override
    public void destroyDistributedObject(String name, boolean local) {
        this.destroyContainer(this.getRingbufferPartitionId(name), RingbufferService.getRingbufferNamespace(name));
        this.nodeEngine.getEventService().deregisterAllListeners(SERVICE_NAME, name);
        this.splitBrainProtectionConfigCache.remove(name);
    }

    public void destroyContainer(int partitionId, ObjectNamespace namespace) {
        Map partitionContainers = (Map)this.containers.get(partitionId);
        if (partitionContainers == null) {
            return;
        }
        partitionContainers.remove(namespace);
    }

    @Override
    public void reset() {
        this.containers.clear();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    public <T, E> RingbufferContainer<T, E> getOrCreateContainer(int partitionId, ObjectNamespace namespace, RingbufferConfig config) {
        if (config == null) {
            throw new NullPointerException("Ringbuffer config must not be null when ringbuffer is being created");
        }
        Map<ObjectNamespace, RingbufferContainer> partitionContainers = this.getOrCreateRingbufferContainers(partitionId);
        RingbufferContainer ringbuffer = partitionContainers.get(namespace);
        if (ringbuffer != null) {
            return ringbuffer;
        }
        ringbuffer = new RingbufferContainer(namespace, config, this.nodeEngine, partitionId);
        ringbuffer.getStore().instrument(this.nodeEngine);
        partitionContainers.put(namespace, ringbuffer);
        return ringbuffer;
    }

    public <T, E> RingbufferContainer<T, E> getContainerOrNull(int partitionId, ObjectNamespace namespace) {
        Map partitionContainers = (Map)this.containers.get(partitionId);
        return partitionContainers != null ? (RingbufferContainer)partitionContainers.get(namespace) : null;
    }

    private Map<ObjectNamespace, RingbufferContainer> getOrCreateRingbufferContainers(int partitionId) {
        Map partitionContainer = (Map)this.containers.get(partitionId);
        if (partitionContainer == null) {
            this.containers.putIfAbsent(partitionId, new HashMap());
        }
        return (Map)this.containers.get(partitionId);
    }

    public RingbufferConfig getRingbufferConfig(String name) {
        Config config = this.nodeEngine.getConfig();
        return config.findRingbufferConfig(RingbufferService.getConfigName(name));
    }

    public static ObjectNamespace getRingbufferNamespace(String name) {
        return new DistributedObjectNamespace(SERVICE_NAME, name);
    }

    public int getRingbufferPartitionId(String ringbufferName) {
        Object partitionAwareData = this.serializationService.toData(ringbufferName, StringPartitioningStrategy.INSTANCE);
        return this.partitionService.getPartitionId((Data)partitionAwareData);
    }

    public void addRingbuffer(int partitionId, RingbufferContainer ringbuffer, RingbufferConfig config) {
        Preconditions.checkNotNull(ringbuffer, "ringbuffer can't be null");
        ringbuffer.init(config, this.nodeEngine);
        ringbuffer.getStore().instrument(this.nodeEngine);
        this.getOrCreateRingbufferContainers(partitionId).put(ringbuffer.getNamespace(), ringbuffer);
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent partitionMigrationEvent) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        return this.prepareReplicationOperation(event, this.getAllServiceNamespaces(event));
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event, Collection<ServiceNamespace> namespaces) {
        int partitionId = event.getPartitionId();
        Map partitionContainers = (Map)this.containers.get(partitionId);
        if (MapUtil.isNullOrEmpty(partitionContainers)) {
            return null;
        }
        HashMap<ObjectNamespace, RingbufferContainer> migrationData = new HashMap<ObjectNamespace, RingbufferContainer>();
        for (ServiceNamespace namespace : namespaces) {
            ObjectNamespace ns = (ObjectNamespace)namespace;
            RingbufferContainer container = (RingbufferContainer)partitionContainers.get(ns);
            if (container == null || container.getConfig().getTotalBackupCount() < event.getReplicaIndex()) continue;
            migrationData.put(ns, container);
        }
        if (migrationData.isEmpty()) {
            return null;
        }
        return new ReplicationOperation(migrationData, event.getPartitionId(), event.getReplicaIndex());
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearRingbuffersHavingLesserBackupCountThan(event.getPartitionId(), event.getNewReplicaIndex());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.DESTINATION) {
            this.clearRingbuffersHavingLesserBackupCountThan(event.getPartitionId(), event.getCurrentReplicaIndex());
        }
    }

    private void clearRingbuffersHavingLesserBackupCountThan(int partitionId, int thresholdReplicaIndex) {
        Map partitionContainers = (Map)this.containers.get(partitionId);
        if (partitionContainers == null || partitionContainers.isEmpty()) {
            return;
        }
        Iterator iterator = partitionContainers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            RingbufferContainer container = (RingbufferContainer)entry.getValue();
            if (thresholdReplicaIndex >= 0 && container.getConfig().getTotalBackupCount() >= thresholdReplicaIndex) continue;
            iterator.remove();
        }
    }

    @Override
    public Collection<ServiceNamespace> getAllServiceNamespaces(PartitionReplicationEvent event) {
        int partitionId = event.getPartitionId();
        Map partitionContainers = (Map)this.containers.get(partitionId);
        if (MapUtil.isNullOrEmpty(partitionContainers)) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<ObjectNamespace> namespaces = Collections.EMPTY_LIST;
        for (RingbufferContainer container : partitionContainers.values()) {
            if (container.getConfig().getTotalBackupCount() < event.getReplicaIndex()) continue;
            if (namespaces == Collections.EMPTY_LIST) {
                namespaces = new LinkedList<ObjectNamespace>();
            }
            namespaces.add(container.getNamespace());
        }
        return namespaces;
    }

    @Override
    public boolean isKnownServiceNamespace(ServiceNamespace namespace) {
        return namespace instanceof ObjectNamespace;
    }

    @Override
    public String getSplitBrainProtectionName(String name) {
        Object splitBrainProtectionName = ConcurrencyUtil.getOrPutSynchronized(this.splitBrainProtectionConfigCache, name, this.splitBrainProtectionConfigCacheMutexFactory, this.splitBrainProtectionConfigConstructor);
        return splitBrainProtectionName == NULL_OBJECT ? null : (String)splitBrainProtectionName;
    }

    public void ensureNoSplitBrain(String distributedObjectName, SplitBrainProtectionOn requiredSplitBrainProtectionPermissionType) {
        this.splitBrainProtectionService.ensureNoSplitBrain(this.getSplitBrainProtectionName(distributedObjectName), requiredSplitBrainProtectionPermissionType);
    }

    @Override
    public Runnable prepareMergeRunnable() {
        RingbufferContainerCollector collector = new RingbufferContainerCollector(this.nodeEngine, this.containers);
        collector.run();
        return new Merger(collector);
    }

    private static String getConfigName(String name) {
        if (name.startsWith(TOPIC_RB_PREFIX)) {
            name = name.substring(TOPIC_RB_PREFIX.length());
        }
        return name;
    }

    private class Merger
    extends AbstractContainerMerger<RingbufferContainer, RingbufferMergeData, SplitBrainMergeTypes.RingbufferMergeTypes> {
        Merger(RingbufferContainerCollector collector) {
            super(collector, RingbufferService.this.nodeEngine);
        }

        @Override
        protected String getLabel() {
            return "ringbuffer";
        }

        @Override
        public void runInternal() {
            for (Map.Entry entry : this.collector.getCollectedContainers().entrySet()) {
                int partitionId = (Integer)entry.getKey();
                Collection containerList = (Collection)entry.getValue();
                for (RingbufferContainer container : containerList) {
                    SplitBrainMergePolicy<RingbufferMergeData, SplitBrainMergeTypes.RingbufferMergeTypes, RingbufferMergeData> mergePolicy = this.getMergePolicy(container.getConfig().getMergePolicyConfig());
                    this.sendBatch(partitionId, mergePolicy, container);
                }
            }
        }

        private void sendBatch(int partitionId, SplitBrainMergePolicy<RingbufferMergeData, SplitBrainMergeTypes.RingbufferMergeTypes, RingbufferMergeData> mergePolicy, RingbufferContainer mergingContainer) {
            MergeOperation operation = new MergeOperation(mergingContainer.getNamespace(), mergePolicy, mergingContainer.getRingbuffer());
            this.invoke(RingbufferService.SERVICE_NAME, operation, partitionId);
        }
    }
}

