/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.validate;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.validate.AbstractNamespace;
import com.hazelcast.org.apache.calcite.sql.validate.SqlUserDefinedTableFunction;
import com.hazelcast.org.apache.calcite.sql.validate.SqlUserDefinedTableMacro;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorImpl;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;

public class ProcedureNamespace
extends AbstractNamespace {
    private final SqlValidatorScope scope;
    private final SqlCall call;

    ProcedureNamespace(SqlValidatorImpl validator, SqlValidatorScope scope, SqlCall call, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.scope = scope;
        this.call = call;
    }

    @Override
    public RelDataType validateImpl(RelDataType targetRowType) {
        this.validator.inferUnknownTypes(this.validator.unknownType, this.scope, this.call);
        RelDataType type = this.validator.deriveTypeImpl(this.scope, this.call);
        SqlOperator operator = this.call.getOperator();
        SqlCallBinding callBinding = new SqlCallBinding(this.validator, this.scope, this.call);
        if (operator instanceof SqlUserDefinedTableFunction) {
            assert (type.getSqlTypeName() == SqlTypeName.CURSOR) : "User-defined table function should have CURSOR type, not " + type;
            SqlUserDefinedTableFunction udf = (SqlUserDefinedTableFunction)operator;
            return udf.getRowType(this.validator.typeFactory, callBinding.operands());
        }
        if (operator instanceof SqlUserDefinedTableMacro) {
            assert (type.getSqlTypeName() == SqlTypeName.CURSOR) : "User-defined table macro should have CURSOR type, not " + type;
            SqlUserDefinedTableMacro udf = (SqlUserDefinedTableMacro)operator;
            return udf.getTable(this.validator.typeFactory, callBinding.operands()).getRowType(this.validator.typeFactory);
        }
        return type;
    }

    @Override
    public SqlNode getNode() {
        return this.call;
    }
}

