/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql;

import com.hazelcast.org.apache.calcite.sql.SqlAbstractStringLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.util.BitString;
import com.hazelcast.org.apache.calcite.util.Util;
import java.util.List;

public class SqlBinaryStringLiteral
extends SqlAbstractStringLiteral {
    protected SqlBinaryStringLiteral(BitString val, SqlParserPos pos) {
        super(val, SqlTypeName.BINARY, pos);
    }

    public BitString getBitString() {
        return (BitString)this.value;
    }

    @Override
    public SqlBinaryStringLiteral clone(SqlParserPos pos) {
        return new SqlBinaryStringLiteral((BitString)this.value, pos);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        assert (this.value instanceof BitString);
        writer.literal("X'" + ((BitString)this.value).toHexString() + "'");
    }

    @Override
    protected SqlAbstractStringLiteral concat1(List<SqlLiteral> literals) {
        return new SqlBinaryStringLiteral(BitString.concat(Util.transform(literals, literal -> ((SqlBinaryStringLiteral)literal).getBitString())), literals.get(0).getParserPosition());
    }
}

