/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.rules;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.rel.core.Aggregate;
import com.hazelcast.org.apache.calcite.rel.core.AggregateCall;
import com.hazelcast.org.apache.calcite.rel.core.RelFactories;
import com.hazelcast.org.apache.calcite.rel.core.Values;
import com.hazelcast.org.apache.calcite.rel.rules.SubstitutionRule;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.org.apache.calcite.tools.RelBuilder;
import com.hazelcast.org.apache.calcite.tools.RelBuilderFactory;
import com.hazelcast.org.apache.calcite.util.Util;
import java.math.BigDecimal;
import java.util.ArrayList;

public class AggregateValuesRule
extends RelOptRule
implements SubstitutionRule {
    public static final AggregateValuesRule INSTANCE = new AggregateValuesRule(RelFactories.LOGICAL_BUILDER);

    public AggregateValuesRule(RelBuilderFactory relBuilderFactory) {
        super(AggregateValuesRule.operandJ(Aggregate.class, null, aggregate -> aggregate.getGroupCount() == 0, AggregateValuesRule.operandJ(Values.class, null, values -> values.getTuples().isEmpty(), AggregateValuesRule.none()), new RelOptRuleOperand[0]), relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        Values values = (Values)call.rel(1);
        Util.discard(values);
        RelBuilder relBuilder = call.builder();
        RexBuilder rexBuilder = relBuilder.getRexBuilder();
        ArrayList<RexLiteral> literals = new ArrayList<RexLiteral>();
        block4: for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
            switch (aggregateCall.getAggregation().getKind()) {
                case COUNT: 
                case SUM0: {
                    literals.add((RexLiteral)rexBuilder.makeLiteral((Object)BigDecimal.ZERO, aggregateCall.getType(), false));
                    continue block4;
                }
                case MIN: 
                case MAX: 
                case SUM: {
                    literals.add(rexBuilder.makeNullLiteral(aggregateCall.getType()));
                    continue block4;
                }
            }
            return;
        }
        call.transformTo(relBuilder.values(ImmutableList.of(literals), aggregate.getRowType()).build());
        call.getPlanner().prune(aggregate);
    }
}

