/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.rules;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.apache.calcite.plan.RelOptRule;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleCall;
import com.hazelcast.org.apache.calcite.plan.RelOptRuleOperand;
import com.hazelcast.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.core.Aggregate;
import com.hazelcast.org.apache.calcite.rel.core.AggregateCall;
import com.hazelcast.org.apache.calcite.rel.core.Join;
import com.hazelcast.org.apache.calcite.rel.core.JoinRelType;
import com.hazelcast.org.apache.calcite.rel.core.RelFactories;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalAggregate;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalJoin;
import com.hazelcast.org.apache.calcite.rel.rules.TransformationRule;
import com.hazelcast.org.apache.calcite.tools.RelBuilder;
import com.hazelcast.org.apache.calcite.tools.RelBuilderFactory;
import com.hazelcast.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.org.apache.calcite.util.mapping.Mappings;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class AggregateJoinRemoveRule
extends RelOptRule
implements TransformationRule {
    public static final AggregateJoinRemoveRule INSTANCE = new AggregateJoinRemoveRule(LogicalAggregate.class, LogicalJoin.class, RelFactories.LOGICAL_BUILDER);

    public AggregateJoinRemoveRule(Class<? extends Aggregate> aggregateClass, Class<? extends Join> joinClass, RelBuilderFactory relBuilderFactory) {
        super(AggregateJoinRemoveRule.operand(aggregateClass, AggregateJoinRemoveRule.operandJ(joinClass, null, join -> join.getJoinType() == JoinRelType.LEFT || join.getJoinType() == JoinRelType.RIGHT, AggregateJoinRemoveRule.any()), new RelOptRuleOperand[0]), relBuilderFactory, null);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        RelNode node;
        Aggregate aggregate = (Aggregate)call.rel(0);
        Join join = (Join)call.rel(1);
        boolean isLeftJoin = join.getJoinType() == JoinRelType.LEFT;
        int lower = isLeftJoin ? join.getLeft().getRowType().getFieldCount() - 1 : 0;
        int upper = isLeftJoin ? join.getRowType().getFieldCount() : join.getLeft().getRowType().getFieldCount();
        Set<Integer> allFields = RelOptUtil.getAllFields(aggregate);
        if (allFields.stream().anyMatch(i -> i >= lower && i < upper)) {
            return;
        }
        if (aggregate.getAggCallList().stream().anyMatch(aggregateCall -> !aggregateCall.isDistinct())) {
            return;
        }
        if (isLeftJoin) {
            node = aggregate.copy(aggregate.getTraitSet(), join.getLeft(), aggregate.getGroupSet(), aggregate.getGroupSets(), aggregate.getAggCallList());
        } else {
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
            allFields.forEach(index -> map.put((Integer)index, index - upper));
            ImmutableBitSet groupSet = aggregate.getGroupSet().permute(map);
            ImmutableList.Builder aggCalls = ImmutableList.builder();
            int sourceCount = aggregate.getInput().getRowType().getFieldCount();
            Mappings.TargetMapping targetMapping = Mappings.target(map, sourceCount, sourceCount);
            aggregate.getAggCallList().forEach(aggregateCall -> aggCalls.add(aggregateCall.transform(targetMapping)));
            RelBuilder relBuilder = call.builder();
            node = relBuilder.push(join.getRight()).aggregate(relBuilder.groupKey(groupSet), (List<AggregateCall>)((Object)aggCalls.build())).build();
        }
        call.transformTo(node);
    }
}

