/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.core.EntryView;
import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.EntryCostEstimator;
import com.hazelcast.map.impl.OwnedEntryCostEstimatorFactory;
import com.hazelcast.map.impl.iterator.MapEntriesWithCursor;
import com.hazelcast.map.impl.iterator.MapKeysWithCursor;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.LazyEvictableEntryView;
import com.hazelcast.map.impl.recordstore.Storage;
import com.hazelcast.map.impl.recordstore.StorageSCHM;
import com.hazelcast.map.impl.recordstore.expiry.ExpirySystem;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StorageImpl<R extends Record>
implements Storage<Data, R> {
    private final StorageSCHM<R> records;
    private final SerializationService serializationService;
    private final InMemoryFormat inMemoryFormat;
    private EntryCostEstimator<Data, Record> entryCostEstimator;

    StorageImpl(InMemoryFormat inMemoryFormat, ExpirySystem expirySystem, SerializationService serializationService) {
        this.entryCostEstimator = OwnedEntryCostEstimatorFactory.createMapSizeEstimator(inMemoryFormat);
        this.inMemoryFormat = inMemoryFormat;
        this.records = new StorageSCHM(serializationService, expirySystem);
        this.serializationService = serializationService;
    }

    @Override
    public void clear(boolean isDuringShutdown) {
        this.records.clear();
        this.entryCostEstimator.reset();
    }

    @Override
    public Iterator<Map.Entry<Data, R>> mutationTolerantIterator() {
        return this.records.cachedEntrySet().iterator();
    }

    @Override
    public void put(Data key, R record) {
        Record previousRecord = (Record)this.records.put(key, record);
        if (previousRecord == null) {
            this.updateCostEstimate(this.entryCostEstimator.calculateEntryCost(key, (Record)record));
        } else {
            this.updateCostEstimate(-this.entryCostEstimator.calculateValueCost(previousRecord));
            this.updateCostEstimate(this.entryCostEstimator.calculateValueCost((Record)record));
        }
    }

    @Override
    public void updateRecordValue(Data key, R record, Object value) {
        this.updateCostEstimate(-this.entryCostEstimator.calculateValueCost((Record)record));
        record.setValue(this.inMemoryFormat == InMemoryFormat.BINARY ? this.serializationService.toData(value) : this.serializationService.toObject(value));
        this.updateCostEstimate(this.entryCostEstimator.calculateValueCost((Record)record));
    }

    @Override
    public R get(Data key) {
        return (R)((Record)this.records.get(key));
    }

    @Override
    public R getIfSameKey(Data key) {
        throw new UnsupportedOperationException("StorageImpl#getIfSameKey");
    }

    @Override
    public int size() {
        return this.records.size();
    }

    @Override
    public boolean isEmpty() {
        return this.records.isEmpty();
    }

    @Override
    public void destroy(boolean isDuringShutdown) {
        this.clear(isDuringShutdown);
    }

    @Override
    public EntryCostEstimator getEntryCostEstimator() {
        return this.entryCostEstimator;
    }

    @Override
    public boolean containsKey(Data key) {
        return this.records.containsKey(key);
    }

    @Override
    public void removeRecord(Data dataKey, R record) {
        this.records.remove(dataKey);
        this.updateCostEstimate(-this.entryCostEstimator.calculateEntryCost(dataKey, (Record)record));
    }

    protected void updateCostEstimate(long entrySize) {
        this.entryCostEstimator.adjustEstimateBy(entrySize);
    }

    @Override
    public void setEntryCostEstimator(EntryCostEstimator entryCostEstimator) {
        this.entryCostEstimator = entryCostEstimator;
    }

    @Override
    public Iterable getRandomSamples(int sampleCount) {
        return this.records.getRandomSamples(sampleCount);
    }

    @Override
    public MapKeysWithCursor fetchKeys(IterationPointer[] pointers, int size) {
        ArrayList<Data> keys = new ArrayList<Data>(size);
        IterationPointer[] newPointers = this.records.fetchKeys(pointers, size, keys);
        return new MapKeysWithCursor((List<Data>)keys, newPointers);
    }

    @Override
    public MapEntriesWithCursor fetchEntries(IterationPointer[] pointers, int size) {
        ArrayList entries = new ArrayList(size);
        IterationPointer[] newPointers = this.records.fetchEntries(pointers, size, entries);
        ArrayList<Map.Entry<Data, Data>> entriesData = new ArrayList<Map.Entry<Data, Data>>(entries.size());
        for (Map.Entry entry : entries) {
            Record record = (Record)entry.getValue();
            Object dataValue = this.serializationService.toData(record.getValue());
            entriesData.add(new AbstractMap.SimpleEntry(entry.getKey(), dataValue));
        }
        return new MapEntriesWithCursor((List<Map.Entry<Data, Data>>)entriesData, newPointers);
    }

    @Override
    public Record extractRecordFromLazy(EntryView entryView) {
        return ((LazyEvictableEntryView)entryView).getRecord();
    }

    @Override
    public Data extractDataKeyFromLazy(EntryView entryView) {
        return ((LazyEvictableEntryView)entryView).getDataKey();
    }

    @Override
    public Data toBackingDataKeyFormat(Data key) {
        return key;
    }
}

