/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.config.AttributeConfig;
import com.hazelcast.config.CachePartitionLostListenerConfig;
import com.hazelcast.config.CacheSimpleConfig;
import com.hazelcast.config.CardinalityEstimatorConfig;
import com.hazelcast.config.ClassFilter;
import com.hazelcast.config.Config;
import com.hazelcast.config.DiscoveryConfig;
import com.hazelcast.config.DurableExecutorConfig;
import com.hazelcast.config.EndpointConfig;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.ExecutorConfig;
import com.hazelcast.config.FlakeIdGeneratorConfig;
import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.InterfacesConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.ItemListenerConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.ListConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapPartitionLostListenerConfig;
import com.hazelcast.config.MemberGroupConfig;
import com.hazelcast.config.MergePolicyConfig;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.OnJoinPermissionOperationName;
import com.hazelcast.config.PNCounterConfig;
import com.hazelcast.config.PermissionConfig;
import com.hazelcast.config.PersistentMemoryConfig;
import com.hazelcast.config.PersistentMemoryDirectoryConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.QueueConfig;
import com.hazelcast.config.ReliableTopicConfig;
import com.hazelcast.config.ReplicatedMapConfig;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.config.ScheduledExecutorConfig;
import com.hazelcast.config.SecurityConfig;
import com.hazelcast.config.SecurityInterceptorConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.config.ServerSocketEndpointConfig;
import com.hazelcast.config.SetConfig;
import com.hazelcast.config.SplitBrainProtectionConfig;
import com.hazelcast.config.SplitBrainProtectionListenerConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.TopicConfig;
import com.hazelcast.config.TrustedInterfacesConfigurable;
import com.hazelcast.config.WanBatchPublisherConfig;
import com.hazelcast.config.WanCustomPublisherConfig;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.config.WanReplicationRef;
import com.hazelcast.config.cp.CPSubsystemConfig;
import com.hazelcast.config.cp.FencedLockConfig;
import com.hazelcast.config.cp.SemaphoreConfig;
import com.hazelcast.config.security.JaasAuthenticationConfig;
import com.hazelcast.config.security.RealmConfig;
import com.hazelcast.config.security.TokenEncoding;
import com.hazelcast.config.security.TokenIdentityConfig;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.config.ConfigUtils;
import com.hazelcast.internal.config.DomConfigHelper;
import com.hazelcast.internal.config.MemberDomConfigProcessor;
import com.hazelcast.internal.config.yaml.W3cDomUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.internal.yaml.YamlMapping;
import com.hazelcast.internal.yaml.YamlNode;
import com.hazelcast.internal.yaml.YamlScalar;
import com.hazelcast.internal.yaml.YamlSequence;
import com.hazelcast.internal.yaml.YamlUtil;
import com.hazelcast.query.impl.IndexUtils;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class YamlMemberDomConfigProcessor
extends MemberDomConfigProcessor {
    public YamlMemberDomConfigProcessor(boolean domLevel3, Config config) {
        super(domLevel3, config);
    }

    public YamlMemberDomConfigProcessor(boolean domLevel3, Config config, boolean strict) {
        super(domLevel3, config, strict);
    }

    @Override
    protected void handleSecurityInterceptorsChild(SecurityConfig cfg, Node child) {
        String className = child.getTextContent();
        cfg.addSecurityInterceptorConfig(new SecurityInterceptorConfig(className));
    }

    @Override
    protected void handleSecurityPermissions(Node node) {
        String onJoinOp = this.getAttribute(node, "on-join-operation");
        if (onJoinOp != null) {
            OnJoinPermissionOperationName onJoinPermissionOperation = OnJoinPermissionOperationName.valueOf(StringUtil.upperCaseInternal(onJoinOp));
            this.config.getSecurityConfig().setOnJoinPermissionOperation(onJoinPermissionOperation);
        }
        Iterable<Node> nodes = DomConfigHelper.childElements(node);
        for (Node child : nodes) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (this.matches("on-join-operation", nodeName)) continue;
            PermissionConfig.PermissionType type = PermissionConfig.PermissionType.getType(nodeName = this.matches("all", nodeName) ? nodeName + "-permissions" : nodeName + "-permission");
            if (type == null) {
                throw new InvalidConfigurationException("Security permission type is not valid " + nodeName);
            }
            if (PermissionConfig.PermissionType.CONFIG == type || PermissionConfig.PermissionType.ALL == type || PermissionConfig.PermissionType.TRANSACTION == type) {
                this.handleSecurityPermission(child, type);
                continue;
            }
            this.handleSecurityPermissionGroup(child, type);
        }
    }

    private void handleSecurityPermissionGroup(Node node, PermissionConfig.PermissionType type) {
        for (Node permissionNode : DomConfigHelper.childElements(node)) {
            this.handleSecurityPermission(permissionNode, type);
        }
    }

    @Override
    void handleSecurityPermissionActions(Node node, PermissionConfig permConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            permConfig.addAction(this.getTextContent(child));
        }
    }

    @Override
    void handleSecurityPermissionEndpoints(Node node, PermissionConfig permConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            permConfig.addEndpoint(this.getTextContent(child).trim());
        }
    }

    @Override
    protected void handleTrustedInterfaces(TrustedInterfacesConfigurable<?> tiConfig, Node n) {
        YamlSequence yamlNode = W3cDomUtil.getWrappedYamlSequence(n);
        for (YamlNode interfaceNode : yamlNode.children()) {
            String trustedInterface = (String)YamlUtil.asScalar(interfaceNode).nodeValue();
            tiConfig.addTrustedInterface(trustedInterface);
        }
        super.handleTrustedInterfaces(tiConfig, n);
    }

    @Override
    protected void handleWanReplication(Node node) {
        for (Node wanReplicationNode : DomConfigHelper.childElements(node)) {
            WanReplicationConfig wanReplicationConfig = new WanReplicationConfig();
            wanReplicationConfig.setName(wanReplicationNode.getNodeName());
            this.handleWanReplicationNode(wanReplicationNode, wanReplicationConfig);
        }
    }

    @Override
    protected void handleWanReplicationChild(WanReplicationConfig wanReplicationConfig, Node nodeTarget, String nodeName) {
        if (this.matches("batch-publisher", nodeName)) {
            for (Node publisherNode : DomConfigHelper.childElements(nodeTarget)) {
                WanBatchPublisherConfig publisherConfig = new WanBatchPublisherConfig();
                String clusterNameOrPublisherId = publisherNode.getNodeName();
                Node clusterNameAttr = this.getNamedItemNode(publisherNode, "cluster-name");
                String clusterName = clusterNameAttr != null ? clusterNameAttr.getTextContent() : clusterNameOrPublisherId;
                String publisherId = clusterNameAttr != null ? clusterNameOrPublisherId : null;
                publisherConfig.setPublisherId(publisherId);
                publisherConfig.setClusterName(clusterName);
                this.handleBatchWanPublisherNode(wanReplicationConfig, publisherNode, publisherConfig);
            }
        } else if (this.matches("custom-publisher", nodeName)) {
            for (Node publisherNode : DomConfigHelper.childElements(nodeTarget)) {
                WanCustomPublisherConfig publisherConfig = new WanCustomPublisherConfig();
                publisherConfig.setPublisherId(publisherNode.getNodeName());
                this.handleCustomWanPublisherNode(wanReplicationConfig, publisherNode, publisherConfig);
            }
        } else if (this.matches("consumer", nodeName)) {
            this.handleWanConsumerNode(wanReplicationConfig, nodeTarget);
        }
    }

    @Override
    protected void handlePort(Node node, Config config) {
        NetworkConfig networkConfig = config.getNetworkConfig();
        NamedNodeMap attributes = node.getAttributes();
        for (int a = 0; a < attributes.getLength(); ++a) {
            int portCount;
            Node att = attributes.item(a);
            if (this.matches("port", att.getNodeName())) {
                portCount = Integer.parseInt(this.getTextContent(att));
                networkConfig.setPort(portCount);
                continue;
            }
            if (this.matches("auto-increment", att.getNodeName())) {
                networkConfig.setPortAutoIncrement(DomConfigHelper.getBooleanValue(this.getTextContent(att)));
                continue;
            }
            if (!this.matches("port-count", att.getNodeName())) continue;
            portCount = Integer.parseInt(this.getTextContent(att));
            networkConfig.setPortCount(portCount);
        }
    }

    @Override
    protected void handleQueue(Node node) {
        for (Node queueNode : DomConfigHelper.childElements(node)) {
            QueueConfig queueConfig = ConfigUtils.getByNameOrNew(this.config.getQueueConfigs(), queueNode.getNodeName(), QueueConfig.class);
            this.handleQueueNode(queueNode, queueConfig);
        }
    }

    @Override
    protected void handleList(Node node) {
        for (Node listNode : DomConfigHelper.childElements(node)) {
            ListConfig listConfig = ConfigUtils.getByNameOrNew(this.config.getListConfigs(), listNode.getNodeName(), ListConfig.class);
            this.handleListNode(listNode, listConfig);
        }
    }

    @Override
    protected void handleSet(Node node) {
        for (Node setNode : DomConfigHelper.childElements(node)) {
            SetConfig setConfig = ConfigUtils.getByNameOrNew(this.config.getSetConfigs(), setNode.getNodeName(), SetConfig.class);
            this.handleSetNode(setNode, setConfig);
        }
    }

    @Override
    protected void handleReliableTopic(Node node) {
        for (Node topicNode : DomConfigHelper.childElements(node)) {
            ReliableTopicConfig topicConfig = new ReliableTopicConfig();
            topicConfig.setName(topicNode.getNodeName());
            this.handleReliableTopicNode(topicNode, topicConfig);
        }
    }

    @Override
    protected void handleTopic(Node node) {
        for (Node topicNode : DomConfigHelper.childElements(node)) {
            TopicConfig topicConfig = new TopicConfig();
            topicConfig.setName(topicNode.getNodeName());
            this.handleTopicNode(topicNode, topicConfig);
        }
    }

    @Override
    protected void handleRingbuffer(Node node) {
        for (Node rbNode : DomConfigHelper.childElements(node)) {
            this.handleRingBufferNode(rbNode, ConfigUtils.getByNameOrNew(this.config.getRingbufferConfigs(), rbNode.getNodeName(), RingbufferConfig.class));
        }
    }

    @Override
    protected void handleMap(Node parentNode) throws Exception {
        for (Node mapNode : DomConfigHelper.childElements(parentNode)) {
            String name = mapNode.getNodeName();
            MapConfig mapConfig = ConfigUtils.getByNameOrNew(this.config.getMapConfigs(), name, MapConfig.class);
            this.handleMapNode(mapNode, mapConfig);
        }
    }

    @Override
    protected void handleCache(Node parentNode) throws Exception {
        for (Node cacheNode : DomConfigHelper.childElements(parentNode)) {
            this.handleCacheNode(cacheNode, ConfigUtils.getByNameOrNew(this.config.getCacheConfigs(), cacheNode.getNodeName(), CacheSimpleConfig.class));
        }
    }

    @Override
    protected void handleSplitBrainProtection(Node node) {
        for (Node splitBrainProtectionNode : DomConfigHelper.childElements(node)) {
            String name = splitBrainProtectionNode.getNodeName();
            SplitBrainProtectionConfig splitBrainProtectionConfig = ConfigUtils.getByNameOrNew(this.config.getSplitBrainProtectionConfigs(), name, SplitBrainProtectionConfig.class);
            this.handleSplitBrainProtectionNode(splitBrainProtectionNode, splitBrainProtectionConfig, name);
        }
    }

    @Override
    protected void handleFlakeIdGenerator(Node node) {
        for (Node genNode : DomConfigHelper.childElements(node)) {
            FlakeIdGeneratorConfig genConfig = ConfigUtils.getByNameOrNew(this.config.getFlakeIdGeneratorConfigs(), genNode.getNodeName(), FlakeIdGeneratorConfig.class);
            this.handleFlakeIdGeneratorNode(genNode, genConfig);
        }
    }

    @Override
    protected void handleExecutor(Node node) throws Exception {
        for (Node executorNode : DomConfigHelper.childElements(node)) {
            ExecutorConfig executorConfig = ConfigUtils.getByNameOrNew(this.config.getExecutorConfigs(), executorNode.getNodeName(), ExecutorConfig.class);
            this.handleViaReflection(executorNode, this.config, executorConfig, new String[0]);
        }
    }

    @Override
    protected void handleDurableExecutor(Node node) throws Exception {
        for (Node executorNode : DomConfigHelper.childElements(node)) {
            DurableExecutorConfig executorConfig = ConfigUtils.getByNameOrNew(this.config.getDurableExecutorConfigs(), executorNode.getNodeName(), DurableExecutorConfig.class);
            this.handleViaReflection(executorNode, this.config, executorConfig, new String[0]);
        }
    }

    @Override
    protected void handleScheduledExecutor(Node node) {
        for (Node executorNode : DomConfigHelper.childElements(node)) {
            ScheduledExecutorConfig executorConfig = ConfigUtils.getByNameOrNew(this.config.getScheduledExecutorConfigs(), executorNode.getNodeName(), ScheduledExecutorConfig.class);
            this.handleScheduledExecutorNode(executorNode, executorConfig);
        }
    }

    @Override
    protected void handleCardinalityEstimator(Node node) {
        for (Node estimatorNode : DomConfigHelper.childElements(node)) {
            CardinalityEstimatorConfig estimatorConfig = ConfigUtils.getByNameOrNew(this.config.getCardinalityEstimatorConfigs(), estimatorNode.getNodeName(), CardinalityEstimatorConfig.class);
            this.handleCardinalityEstimatorNode(estimatorNode, estimatorConfig);
        }
    }

    @Override
    protected void handlePNCounter(Node node) throws Exception {
        for (Node counterNode : DomConfigHelper.childElements(node)) {
            PNCounterConfig counterConfig = ConfigUtils.getByNameOrNew(this.config.getPNCounterConfigs(), counterNode.getNodeName(), PNCounterConfig.class);
            this.handleViaReflection(counterNode, this.config, counterConfig, new String[0]);
        }
    }

    @Override
    protected void handleMultiMap(Node node) {
        for (Node multiMapNode : DomConfigHelper.childElements(node)) {
            MultiMapConfig multiMapConfig = ConfigUtils.getByNameOrNew(this.config.getMultiMapConfigs(), multiMapNode.getNodeName(), MultiMapConfig.class);
            this.handleMultiMapNode(multiMapNode, multiMapConfig);
        }
    }

    @Override
    protected void handleReplicatedMap(Node node) {
        for (Node replicatedMapNode : DomConfigHelper.childElements(node)) {
            ReplicatedMapConfig replicatedMapConfig = ConfigUtils.getByNameOrNew(this.config.getReplicatedMapConfigs(), replicatedMapNode.getNodeName(), ReplicatedMapConfig.class);
            this.handleReplicatedMapNode(replicatedMapNode, replicatedMapConfig);
        }
    }

    @Override
    protected void mapWanReplicationRefHandle(Node n, MapConfig mapConfig) {
        for (Node mapNode : DomConfigHelper.childElements(n)) {
            WanReplicationRef wanReplicationRef = new WanReplicationRef();
            wanReplicationRef.setName(mapNode.getNodeName());
            this.handleMapWanReplicationRefNode(mapNode, mapConfig, wanReplicationRef);
        }
    }

    @Override
    protected void handleWanFilters(Node wanChild, WanReplicationRef wanReplicationRef) {
        for (Node filter : DomConfigHelper.childElements(wanChild)) {
            wanReplicationRef.addFilter(this.getTextContent(filter));
        }
    }

    @Override
    protected void mapIndexesHandle(Node n, MapConfig mapConfig) {
        for (Node indexNode : DomConfigHelper.childElements(n)) {
            IndexConfig indexConfig = IndexUtils.getIndexConfigFromYaml(indexNode, this.domLevel3, this.strict);
            mapConfig.addIndexConfig(indexConfig);
        }
    }

    @Override
    protected void attributesHandle(Node n, MapConfig mapConfig) {
        for (Node extractorNode : DomConfigHelper.childElements(n)) {
            String extractor = this.getTextContent(this.getNamedItemNode(extractorNode, "extractor-class-name"));
            String name = extractorNode.getNodeName();
            mapConfig.addAttributeConfig(new AttributeConfig(name, extractor));
        }
    }

    @Override
    protected void mapQueryCacheHandler(Node n, MapConfig mapConfig) {
        for (Node queryCacheNode : DomConfigHelper.childElements(n)) {
            String cacheName = queryCacheNode.getNodeName();
            QueryCacheConfig queryCacheConfig = new QueryCacheConfig(cacheName);
            this.handleMapQueryCacheNode(mapConfig, queryCacheNode, queryCacheConfig);
        }
    }

    @Override
    protected void queryCachePredicateHandler(Node childNode, QueryCacheConfig queryCacheConfig) {
        Node classNameNode = this.getNamedItemNode(childNode, "class-name");
        Node sqlNode = this.getNamedItemNode(childNode, "sql");
        if (classNameNode != null && sqlNode != null) {
            throw new InvalidConfigurationException("Both class-name and sql is defined for the predicate of map " + childNode.getParentNode().getParentNode().getNodeName());
        }
        if (classNameNode == null && sqlNode == null) {
            throw new InvalidConfigurationException("Either class-name and sql must be defined for the predicate of map " + childNode.getParentNode().getParentNode().getNodeName());
        }
        PredicateConfig predicateConfig = new PredicateConfig();
        if (classNameNode != null) {
            predicateConfig.setClassName(this.getTextContent(classNameNode));
        } else if (sqlNode != null) {
            predicateConfig.setSql(this.getTextContent(sqlNode));
        }
        queryCacheConfig.setPredicateConfig(predicateConfig);
    }

    @Override
    protected void queryCacheIndexesHandle(Node n, QueryCacheConfig queryCacheConfig) {
        for (Node indexNode : DomConfigHelper.childElements(n)) {
            IndexConfig indexConfig = IndexUtils.getIndexConfigFromYaml(indexNode, this.domLevel3, this.strict);
            queryCacheConfig.addIndexConfig(indexConfig);
        }
    }

    @Override
    protected void handleMemberGroup(Node node, Config config) {
        for (Node memberGroupNode : DomConfigHelper.childElements(node)) {
            MemberGroupConfig memberGroupConfig = new MemberGroupConfig();
            for (Node interfacesNode : DomConfigHelper.childElements(memberGroupNode)) {
                memberGroupConfig.addInterface(interfacesNode.getNodeValue().trim());
            }
            config.getPartitionGroupConfig().addMemberGroupConfig(memberGroupConfig);
        }
    }

    @Override
    protected MergePolicyConfig createMergePolicyConfig(Node node, MergePolicyConfig baseMergePolicyConfig) {
        String att;
        String policyString = this.getTextContent(this.getNamedItemNode(node, "class-name"));
        if (policyString != null) {
            baseMergePolicyConfig.setPolicy(policyString);
        }
        if ((att = this.getAttribute(node, "batch-size")) != null) {
            baseMergePolicyConfig.setBatchSize(DomConfigHelper.getIntegerValue("batch-size", att));
        }
        return baseMergePolicyConfig;
    }

    @Override
    protected void mapPartitionLostListenerHandle(Node n, MapConfig mapConfig) {
        for (Node listenerNode : DomConfigHelper.childElements(n)) {
            String listenerClass = listenerNode.getNodeValue();
            mapConfig.addMapPartitionLostListenerConfig(new MapPartitionLostListenerConfig(listenerClass));
        }
    }

    @Override
    protected void cachePartitionLostListenerHandle(Node n, CacheSimpleConfig cacheConfig) {
        for (Node listenerNode : DomConfigHelper.childElements(n)) {
            String listenerClass = listenerNode.getNodeValue();
            cacheConfig.addCachePartitionLostListenerConfig(new CachePartitionLostListenerConfig(listenerClass));
        }
    }

    @Override
    protected void cacheListenerHandle(Node n, CacheSimpleConfig cacheSimpleConfig) {
        for (Node listenerNode : DomConfigHelper.childElements(n)) {
            this.handleCacheEntryListenerNode(cacheSimpleConfig, listenerNode);
        }
    }

    @Override
    protected void handleItemListeners(Node n, Consumer<ItemListenerConfig> configAddFunction) {
        for (Node listenerNode : DomConfigHelper.childElements(n)) {
            boolean incValue = DomConfigHelper.getBooleanValue(this.getTextContent(this.getNamedItemNode(listenerNode, "include-value")));
            String listenerClass = this.getTextContent(this.getNamedItemNode(listenerNode, "class-name"));
            configAddFunction.accept(new ItemListenerConfig(listenerClass, incValue));
        }
    }

    @Override
    protected void handleEntryListeners(Node n, Consumer<EntryListenerConfig> configAddFunction) {
        for (Node listenerNode : DomConfigHelper.childElements(n)) {
            boolean incValue = DomConfigHelper.getBooleanValue(this.getTextContent(this.getNamedItemNode(listenerNode, "include-value")));
            boolean local = DomConfigHelper.getBooleanValue(this.getTextContent(this.getNamedItemNode(listenerNode, "local")));
            String listenerClass = this.getTextContent(this.getNamedItemNode(listenerNode, "class-name"));
            configAddFunction.accept(new EntryListenerConfig(listenerClass, local, incValue));
        }
    }

    @Override
    void handleMessageListeners(Node n, Function<ListenerConfig, Void> configAddFunction) {
        for (Node listenerNode : DomConfigHelper.childElements(n)) {
            String listenerClass = listenerNode.getNodeValue().trim();
            configAddFunction.apply(new ListenerConfig(listenerClass));
        }
    }

    @Override
    protected void handleSplitBrainProtectionListeners(SplitBrainProtectionConfig splitBrainProtectionConfig, Node n) {
        for (Node listenerNode : DomConfigHelper.childElements(n)) {
            String listenerClass = listenerNode.getNodeValue().trim();
            splitBrainProtectionConfig.addListenerConfig(new SplitBrainProtectionListenerConfig(listenerClass));
        }
    }

    @Override
    protected void fillProperties(Node node, Map<String, Comparable> properties) {
        YamlMapping propertiesMapping = W3cDomUtil.getWrappedYamlMapping(node);
        for (YamlNode propNode : propertiesMapping.children()) {
            YamlScalar propScalar = YamlUtil.asScalar(propNode);
            String key = propScalar.nodeName();
            String value = propScalar.nodeValue().toString();
            properties.put(key, (Comparable)((Object)value));
        }
    }

    @Override
    protected void fillProperties(Node node, Properties properties) {
        YamlMapping propertiesMapping = W3cDomUtil.getWrappedYamlMapping(node);
        for (YamlNode propNode : propertiesMapping.children()) {
            YamlScalar propScalar = YamlUtil.asScalar(propNode);
            String key = propScalar.nodeName();
            String value = propScalar.nodeValue().toString();
            properties.put(key, value);
        }
    }

    @Override
    protected void handleDiscoveryStrategiesChild(DiscoveryConfig discoveryConfig, Node child) {
        String name = DomConfigHelper.cleanNodeName(child);
        if (this.matches("discovery-strategies", name)) {
            NodeList strategies = child.getChildNodes();
            for (int i = 0; i < strategies.getLength(); ++i) {
                Node strategy = strategies.item(i);
                this.handleDiscoveryStrategy(strategy, discoveryConfig);
            }
        } else if (this.matches("node-filter", name)) {
            this.handleDiscoveryNodeFilter(child, discoveryConfig);
        }
    }

    @Override
    protected SerializationConfig parseSerialization(Node node) {
        SerializationConfig serializationConfig = new SerializationConfig();
        for (Node child : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(child);
            if (this.matches("portable-version", name)) {
                serializationConfig.setPortableVersion(DomConfigHelper.getIntegerValue(name, this.getTextContent(child)));
                continue;
            }
            if (this.matches("check-class-def-errors", name)) {
                serializationConfig.setCheckClassDefErrors(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("use-native-byte-order", name)) {
                serializationConfig.setUseNativeByteOrder(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("byte-order", name)) {
                ByteOrder byteOrder = null;
                if (ByteOrder.BIG_ENDIAN.toString().equals(this.getTextContent(child))) {
                    byteOrder = ByteOrder.BIG_ENDIAN;
                } else if (ByteOrder.LITTLE_ENDIAN.toString().equals(this.getTextContent(child))) {
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                }
                serializationConfig.setByteOrder(byteOrder != null ? byteOrder : ByteOrder.BIG_ENDIAN);
                continue;
            }
            if (this.matches("enable-compression", name)) {
                serializationConfig.setEnableCompression(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("enable-shared-object", name)) {
                serializationConfig.setEnableSharedObject(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("allow-unsafe", name)) {
                serializationConfig.setAllowUnsafe(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("allow-override-default-serializers", name)) {
                serializationConfig.setAllowOverrideDefaultSerializers(DomConfigHelper.getBooleanValue(this.getTextContent(child)));
                continue;
            }
            if (this.matches("data-serializable-factories", name)) {
                this.fillDataSerializableFactories(child, serializationConfig);
                continue;
            }
            if (this.matches("portable-factories", name)) {
                this.fillPortableFactories(child, serializationConfig);
                continue;
            }
            if (this.matches("serializers", name)) {
                this.fillSerializers(child, serializationConfig);
                continue;
            }
            if (this.matches("global-serializer", name)) {
                this.fillGlobalSerializer(child, serializationConfig);
                continue;
            }
            if (!this.matches("java-serialization-filter", name)) continue;
            this.fillJavaSerializationFilter(child, serializationConfig);
        }
        return serializationConfig;
    }

    private void fillGlobalSerializer(Node child, SerializationConfig serializationConfig) {
        GlobalSerializerConfig globalSerializerConfig = new GlobalSerializerConfig();
        String attrClassName = this.getAttribute(child, "class-name");
        String attrOverrideJavaSerialization = this.getAttribute(child, "override-java-serialization");
        boolean overrideJavaSerialization = attrOverrideJavaSerialization != null && DomConfigHelper.getBooleanValue(attrOverrideJavaSerialization.trim());
        globalSerializerConfig.setClassName(attrClassName);
        globalSerializerConfig.setOverrideJavaSerialization(overrideJavaSerialization);
        serializationConfig.setGlobalSerializerConfig(globalSerializerConfig);
    }

    @Override
    protected void fillSerializers(Node node, SerializationConfig serializationConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            SerializerConfig serializerConfig = new SerializerConfig();
            String typeClassName = this.getAttribute(child, "type-class");
            String className = this.getAttribute(child, "class-name");
            serializerConfig.setTypeClassName(typeClassName);
            serializerConfig.setClassName(className);
            serializationConfig.addSerializerConfig(serializerConfig);
        }
    }

    @Override
    protected void fillDataSerializableFactories(Node node, SerializationConfig serializationConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            Node factoryIdNode = this.getNamedItemNode(child, "factory-id");
            Node classNameNode = this.getNamedItemNode(child, "class-name");
            if (factoryIdNode == null) {
                throw new IllegalArgumentException("'factory-id' attribute of 'data-serializable-factory' is required!");
            }
            if (classNameNode == null) {
                throw new IllegalArgumentException("'class-name' attribute of 'data-serializable-factory' is required!");
            }
            int factoryId = Integer.parseInt(this.getTextContent(factoryIdNode));
            String className = this.getTextContent(classNameNode);
            serializationConfig.addDataSerializableFactoryClass(factoryId, className);
        }
    }

    @Override
    protected void fillPortableFactories(Node node, SerializationConfig serializationConfig) {
        for (Node child : DomConfigHelper.childElements(node)) {
            Node factoryIdNode = this.getNamedItemNode(child, "factory-id");
            Node classNameNode = this.getNamedItemNode(child, "class-name");
            if (factoryIdNode == null) {
                throw new IllegalArgumentException("'factory-id' attribute of 'portable-factory' is required!");
            }
            if (classNameNode == null) {
                throw new IllegalArgumentException("'class-name' attribute of 'portable-factory' is required!");
            }
            int factoryId = Integer.parseInt(this.getTextContent(factoryIdNode));
            String className = this.getTextContent(classNameNode);
            serializationConfig.addPortableFactoryClass(factoryId, className);
        }
    }

    @Override
    protected ClassFilter parseClassFilterList(Node node) {
        ClassFilter list = new ClassFilter();
        for (Node typeNode : DomConfigHelper.childElements(node)) {
            String name = DomConfigHelper.cleanNodeName(typeNode);
            if (this.matches("class", name)) {
                for (Node classNode : DomConfigHelper.childElements(typeNode)) {
                    list.addClasses(this.getTextContent(classNode));
                }
                continue;
            }
            if (this.matches("package", name)) {
                for (Node packageNode : DomConfigHelper.childElements(typeNode)) {
                    list.addPackages(this.getTextContent(packageNode));
                }
                continue;
            }
            if (!this.matches("prefix", name)) continue;
            for (Node prefixNode : DomConfigHelper.childElements(typeNode)) {
                list.addPrefixes(this.getTextContent(prefixNode));
            }
        }
        return list;
    }

    @Override
    protected void handleMemberAttributes(Node node) {
        for (Node n : DomConfigHelper.childElements(node)) {
            String attributeValue = this.getTextContent(this.getNamedItemNode(n, "value"));
            String attributeName = n.getNodeName();
            this.handleMemberAttributesNode(attributeName, attributeValue);
        }
    }

    @Override
    protected void handleOutboundPorts(Node child) {
        NetworkConfig networkConfig = this.config.getNetworkConfig();
        for (Node n : DomConfigHelper.childElements(child)) {
            networkConfig.addOutboundPortDefinition(this.getTextContent(n));
        }
    }

    @Override
    protected void handleOutboundPorts(Node child, EndpointConfig endpointConfig) {
        for (Node n : DomConfigHelper.childElements(child)) {
            endpointConfig.addOutboundPortDefinition(this.getTextContent(n));
        }
    }

    @Override
    protected void handleInterfacesList(Node node, InterfacesConfig interfaces) {
        for (Node interfacesNode : DomConfigHelper.childElements(node)) {
            if (!this.matches("interfaces", StringUtil.lowerCaseInternal(DomConfigHelper.cleanNodeName(interfacesNode)))) continue;
            for (Node interfaceNode : DomConfigHelper.childElements(interfacesNode)) {
                interfaces.addInterface(this.getTextContent(interfaceNode));
            }
        }
    }

    @Override
    protected void handleListeners(Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String listenerClass = this.getTextContent(child);
            this.config.addListenerConfig(new ListenerConfig(listenerClass));
        }
    }

    @Override
    protected void handleMemberList(Node node, boolean advancedNetworkConfig) {
        JoinConfig join = this.joinConfig(advancedNetworkConfig);
        TcpIpConfig tcpIpConfig = join.getTcpIpConfig();
        for (Node n : DomConfigHelper.childElements(node)) {
            tcpIpConfig.addMember(this.getTextContent(n));
        }
    }

    @Override
    protected void handleRestApiEndpointGroups(Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            String nodeName = DomConfigHelper.cleanNodeName(child);
            if (!this.matches("endpoint-groups", nodeName)) continue;
            for (Node groupNode : DomConfigHelper.childElements(child)) {
                String groupName = groupNode.getNodeName();
                this.handleEndpointGroup(groupNode, groupName);
            }
        }
    }

    @Override
    protected String extractName(Node node) {
        return node.getNodeName();
    }

    @Override
    protected void handlePort(Node node, ServerSocketEndpointConfig endpointConfig) {
        String portStr;
        Node portNode = this.getNamedItemNode(node, "port");
        if (portNode != null && (portStr = portNode.getNodeValue().trim()).length() > 0) {
            endpointConfig.setPort(Integer.parseInt(portStr));
        }
        this.handlePortAttributes(node, endpointConfig);
    }

    @Override
    protected void handleWanServerSocketEndpointConfig(Node node) throws Exception {
        for (Node wanEndpointNode : DomConfigHelper.childElements(node)) {
            ServerSocketEndpointConfig config = new ServerSocketEndpointConfig();
            config.setProtocolType(ProtocolType.WAN);
            String name = wanEndpointNode.getNodeName();
            this.handleServerSocketEndpointConfig(config, wanEndpointNode, name);
        }
    }

    @Override
    protected void handleWanEndpointConfig(Node node) throws Exception {
        for (Node wanEndpointNode : DomConfigHelper.childElements(node)) {
            EndpointConfig config = new EndpointConfig();
            config.setProtocolType(ProtocolType.WAN);
            String endpointName = wanEndpointNode.getNodeName().trim();
            this.handleEndpointConfig(config, wanEndpointNode, endpointName);
        }
    }

    @Override
    void handleSemaphores(CPSubsystemConfig cpSubsystemConfig, Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            SemaphoreConfig semaphoreConfig = new SemaphoreConfig();
            semaphoreConfig.setName(child.getNodeName());
            for (Node subChild : DomConfigHelper.childElements(child)) {
                String nodeName = DomConfigHelper.cleanNodeName(subChild);
                if (this.matches("jdk-compatible", nodeName)) {
                    semaphoreConfig.setJDKCompatible(Boolean.parseBoolean(this.getTextContent(subChild)));
                    continue;
                }
                if (!this.matches("initial-permits", nodeName)) continue;
                semaphoreConfig.setInitialPermits(Integer.parseInt(this.getTextContent(subChild)));
            }
            cpSubsystemConfig.addSemaphoreConfig(semaphoreConfig);
        }
    }

    @Override
    void handleFencedLocks(CPSubsystemConfig cpSubsystemConfig, Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            FencedLockConfig lockConfig = new FencedLockConfig();
            lockConfig.setName(child.getNodeName());
            for (Node subChild : DomConfigHelper.childElements(child)) {
                String nodeName = DomConfigHelper.cleanNodeName(subChild);
                if (!this.matches("lock-acquire-limit", nodeName)) continue;
                lockConfig.setLockAcquireLimit(Integer.parseInt(this.getTextContent(subChild)));
            }
            cpSubsystemConfig.addLockConfig(lockConfig);
        }
    }

    @Override
    protected void handleRealms(Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            this.handleRealm(child);
        }
    }

    @Override
    protected void handleJaasAuthentication(RealmConfig realmConfig, Node node) {
        JaasAuthenticationConfig jaasAuthenticationConfig = new JaasAuthenticationConfig();
        for (Node child : DomConfigHelper.childElements(node)) {
            jaasAuthenticationConfig.addLoginModuleConfig(this.handleLoginModule(child));
        }
        realmConfig.setJaasAuthenticationConfig(jaasAuthenticationConfig);
    }

    @Override
    protected void handleToken(RealmConfig realmConfig, Node node) {
        TokenEncoding encoding = TokenEncoding.getTokenEncoding(this.getAttribute(node, "encoding"));
        TokenIdentityConfig tic = new TokenIdentityConfig(encoding, this.getAttribute(node, "value"));
        realmConfig.setTokenIdentityConfig(tic);
    }

    @Override
    protected void handlePersistentMemoryDirectory(PersistentMemoryConfig persistentMemoryConfig, Node dirNode) {
        String directory = this.getTextContent(this.getNamedItemNode(dirNode, "directory"));
        String numaNodeIdStr = this.getTextContent(this.getNamedItemNode(dirNode, "numa-node"));
        if (!StringUtil.isNullOrEmptyAfterTrim(numaNodeIdStr)) {
            int numaNodeId = DomConfigHelper.getIntegerValue("numa-node", numaNodeIdStr);
            persistentMemoryConfig.addDirectoryConfig(new PersistentMemoryDirectoryConfig(directory, numaNodeId));
        } else {
            persistentMemoryConfig.addDirectoryConfig(new PersistentMemoryDirectoryConfig(directory));
        }
    }
}

