/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAddMigrationListenerCodec;
import com.hazelcast.client.impl.protocol.task.AbstractAddListenerMessageTask;
import com.hazelcast.cluster.Member;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.partition.MigrationListener;
import com.hazelcast.partition.MigrationState;
import com.hazelcast.partition.ReplicaMigrationEvent;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.security.Permission;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public class AddMigrationListenerMessageTask
extends AbstractAddListenerMessageTask<Boolean> {
    public AddMigrationListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected CompletableFuture<UUID> processInternal() {
        IPartitionService partitionService = (IPartitionService)this.getService(this.getServiceName());
        MigrationListener listener = this.createMigrationListener();
        if (((Boolean)this.parameters).booleanValue()) {
            return InternalCompletableFuture.newCompletedFuture(partitionService.addLocalMigrationListener(listener));
        }
        return partitionService.addMigrationListenerAsync(listener);
    }

    private MigrationListener createMigrationListener() {
        return new MigrationListener(){

            @Override
            public void migrationStarted(MigrationState state) {
                AddMigrationListenerMessageTask.this.sendIfAlive(AddMigrationListenerMessageTask.this.encodeMigrationEvent(state, 0));
            }

            @Override
            public void migrationFinished(MigrationState state) {
                AddMigrationListenerMessageTask.this.sendIfAlive(AddMigrationListenerMessageTask.this.encodeMigrationEvent(state, 1));
            }

            @Override
            public void replicaMigrationCompleted(ReplicaMigrationEvent event) {
                AddMigrationListenerMessageTask.this.sendIfAlive(AddMigrationListenerMessageTask.this.encodeReplicaMigrationEvent(event));
            }

            @Override
            public void replicaMigrationFailed(ReplicaMigrationEvent event) {
                AddMigrationListenerMessageTask.this.sendIfAlive(AddMigrationListenerMessageTask.this.encodeReplicaMigrationEvent(event));
            }
        };
    }

    private void sendIfAlive(ClientMessage eventMessage) {
        if (this.endpoint.isAlive()) {
            this.sendClientMessage(".migration".hashCode(), eventMessage);
        }
    }

    private ClientMessage encodeReplicaMigrationEvent(ReplicaMigrationEvent event) {
        return ClientAddMigrationListenerCodec.encodeReplicaMigrationEvent(event.getMigrationState(), event.getPartitionId(), event.getReplicaIndex(), this.getMemberUuid(event.getSource()), this.getMemberUuid(event.getDestination()), event.isSuccess(), event.getElapsedTime());
    }

    @Nullable
    private UUID getMemberUuid(@Nullable Member source) {
        return source != null ? source.getUuid() : null;
    }

    private ClientMessage encodeMigrationEvent(MigrationState migrationState, int type) {
        return ClientAddMigrationListenerCodec.encodeMigrationEvent(migrationState, type);
    }

    @Override
    protected Boolean decodeClientMessage(ClientMessage clientMessage) {
        return ClientAddMigrationListenerCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return ClientAddMigrationListenerCodec.encodeResponse((UUID)response);
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public String getDistributedObjectName() {
        return ".migration";
    }

    @Override
    public String getMethodName() {
        return "addMigrationListener";
    }

    @Override
    public Object[] getParameters() {
        return null;
    }
}

