/*
 * Decompiled with CFR 0.152.
 */
package com.hadoop.mapred;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.util.LineReader;

public class DeprecatedLzoLineRecordReader
implements RecordReader<LongWritable, Text> {
    private CompressionCodecFactory codecFactory = null;
    private long start;
    private long pos;
    private final long end;
    private final LineReader in;
    private final FSDataInputStream fileIn;

    DeprecatedLzoLineRecordReader(Configuration conf, FileSplit split) throws IOException {
        this.start = split.getStart();
        this.end = this.start + split.getLength();
        Path file = split.getPath();
        FileSystem fs = file.getFileSystem(conf);
        this.codecFactory = new CompressionCodecFactory(conf);
        CompressionCodec codec = this.codecFactory.getCodec(file);
        if (codec == null) {
            throw new IOException("No LZO codec found, cannot run.");
        }
        this.fileIn = fs.open(file);
        this.in = new LineReader((InputStream)codec.createInputStream((InputStream)this.fileIn), conf);
        if (this.start != 0L) {
            this.fileIn.seek(this.start);
            this.in.readLine(new Text());
            this.start = this.fileIn.getPos();
        }
        this.pos = this.start;
    }

    public LongWritable createKey() {
        return new LongWritable();
    }

    public Text createValue() {
        return new Text();
    }

    public boolean next(LongWritable key, Text value) throws IOException {
        if (this.pos <= this.end) {
            key.set(this.pos);
            int newSize = this.in.readLine(value);
            if (newSize == 0) {
                return false;
            }
            this.pos = this.fileIn.getPos();
            return true;
        }
        return false;
    }

    public float getProgress() throws IOException {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.pos - this.start) / (float)(this.end - this.start));
    }

    public synchronized long getPos() throws IOException {
        return this.pos;
    }

    public synchronized void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }
}

