/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.io.IOException;
import java.io.InputStream;
import org.h2.store.DataHandler;

class LobStorageRemoteInputStream
extends InputStream {
    private final DataHandler handler;
    private final long lob;
    private final byte[] hmac;
    private long pos;
    private long remainingBytes;

    public LobStorageRemoteInputStream(DataHandler dataHandler, long l, byte[] byArray, long l2) {
        this.handler = dataHandler;
        this.lob = l;
        this.hmac = byArray;
        this.remainingBytes = l2;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        return n < 0 ? n : byArray[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        if ((n2 = (int)Math.min((long)n2, this.remainingBytes)) == 0) {
            return -1;
        }
        n2 = this.handler.readLob(this.lob, this.hmac, this.pos, byArray, n, n2);
        this.remainingBytes -= (long)n2;
        if (n2 == 0) {
            return -1;
        }
        this.pos += (long)n2;
        return n2;
    }

    @Override
    public long skip(long l) {
        this.remainingBytes -= l;
        this.pos += l;
        return l;
    }
}

