/*
 * Decompiled with CFR 0.152.
 */
package org.h2.upgrade;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.h2.upgrade.DbUpgradeNonPageStoreToCurrent;
import org.h2.util.Utils;

public class DbUpgrade {
    private static boolean nonPageStoreToCurrentEnabled = Utils.isClassPresent("org.h2.upgrade.v1_1.Driver");
    private static Map<String, DbUpgradeNonPageStoreToCurrent> runningConversions = Collections.synchronizedMap(new Hashtable(1));

    public static synchronized void upgrade(String string, Properties properties) throws SQLException {
        if (nonPageStoreToCurrentEnabled) {
            DbUpgrade.upgradeFromNonPageStore(string, properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void upgradeFromNonPageStore(String string, Properties properties) throws SQLException {
        if (runningConversions.containsKey(string)) {
            return;
        }
        try {
            DbUpgradeNonPageStoreToCurrent dbUpgradeNonPageStoreToCurrent = new DbUpgradeNonPageStoreToCurrent(string, properties);
            runningConversions.put(string, dbUpgradeNonPageStoreToCurrent);
            dbUpgradeNonPageStoreToCurrent.upgrade();
        }
        finally {
            runningConversions.remove(string);
        }
    }
}

