/*
 * Decompiled with CFR 0.152.
 */
package org.h2.fulltext;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexModifier;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.h2.api.Trigger;
import org.h2.command.Parser;
import org.h2.engine.Session;
import org.h2.expression.ExpressionColumn;
import org.h2.fulltext.FullText;
import org.h2.jdbc.JdbcConnection;
import org.h2.store.fs.FileSystem;
import org.h2.tools.SimpleResultSet;
import org.h2.util.JdbcUtils;
import org.h2.util.New;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;

public class FullTextLucene
extends FullText {
    protected static final boolean STORE_DOCUMENT_TEXT_IN_INDEX = Boolean.getBoolean("h2.storeDocumentTextInIndex");
    private static final HashMap<String, IndexModifier> INDEX_MODIFIERS = New.hashMap();
    private static final String TRIGGER_PREFIX = "FTL_";
    private static final String SCHEMA = "FTL";
    private static final String LUCENE_FIELD_DATA = "_DATA";
    private static final String LUCENE_FIELD_QUERY = "_QUERY";
    private static final String LUCENE_FIELD_MODIFIED = "_modified";
    private static final String LUCENE_FIELD_COLUMN_PREFIX = "_";

    public static void init(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.execute("CREATE SCHEMA IF NOT EXISTS FTL");
        statement.execute("CREATE TABLE IF NOT EXISTS FTL.INDEXES(SCHEMA VARCHAR, TABLE VARCHAR, COLUMNS VARCHAR, PRIMARY KEY(SCHEMA, TABLE))");
        statement.execute("CREATE ALIAS IF NOT EXISTS FTL_CREATE_INDEX FOR \"" + FullTextLucene.class.getName() + ".createIndex\"");
        statement.execute("CREATE ALIAS IF NOT EXISTS FTL_SEARCH FOR \"" + FullTextLucene.class.getName() + ".search\"");
        statement.execute("CREATE ALIAS IF NOT EXISTS FTL_SEARCH_DATA FOR \"" + FullTextLucene.class.getName() + ".searchData\"");
        statement.execute("CREATE ALIAS IF NOT EXISTS FTL_REINDEX FOR \"" + FullTextLucene.class.getName() + ".reindex\"");
        statement.execute("CREATE ALIAS IF NOT EXISTS FTL_DROP_ALL FOR \"" + FullTextLucene.class.getName() + ".dropAll\"");
        try {
            FullTextLucene.getIndexModifier(connection);
        }
        catch (SQLException sQLException) {
            throw FullTextLucene.convertException(sQLException);
        }
    }

    public static void createIndex(Connection connection, String string, String string2, String string3) throws SQLException {
        FullTextLucene.init(connection);
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO FTL.INDEXES(SCHEMA, TABLE, COLUMNS) VALUES(?, ?, ?)");
        preparedStatement.setString(1, string);
        preparedStatement.setString(2, string2);
        preparedStatement.setString(3, string3);
        preparedStatement.execute();
        FullTextLucene.createTrigger(connection, string, string2);
        FullTextLucene.indexExistingRows(connection, string, string2);
    }

    public static void reindex(Connection connection) throws SQLException {
        FullTextLucene.init(connection);
        FullTextLucene.removeAllTriggers(connection, TRIGGER_PREFIX);
        FullTextLucene.removeIndexFiles(connection);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT * FROM FTL.INDEXES");
        while (resultSet.next()) {
            String string = resultSet.getString("SCHEMA");
            String string2 = resultSet.getString("TABLE");
            FullTextLucene.createTrigger(connection, string, string2);
            FullTextLucene.indexExistingRows(connection, string, string2);
        }
    }

    public static void dropAll(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.execute("DROP SCHEMA IF EXISTS FTL");
        FullTextLucene.removeAllTriggers(connection, TRIGGER_PREFIX);
        FullTextLucene.removeIndexFiles(connection);
    }

    public static ResultSet search(Connection connection, String string, int n, int n2) throws SQLException {
        return FullTextLucene.search(connection, string, n, n2, false);
    }

    public static ResultSet searchData(Connection connection, String string, int n, int n2) throws SQLException {
        return FullTextLucene.search(connection, string, n, n2, true);
    }

    protected static SQLException convertException(Exception exception) {
        SQLException sQLException = new SQLException("Error while indexing document", "FULLTEXT");
        sQLException.initCause(exception);
        return sQLException;
    }

    protected static void createTrigger(Connection connection, String string, String string2) throws SQLException {
        Statement statement = connection.createStatement();
        String string3 = StringUtils.quoteIdentifier(string) + "." + StringUtils.quoteIdentifier(TRIGGER_PREFIX + string2);
        statement.execute("DROP TRIGGER IF EXISTS " + string3);
        StringBuilder stringBuilder = new StringBuilder("CREATE TRIGGER IF NOT EXISTS ");
        stringBuilder.append(string3).append(" AFTER INSERT, UPDATE, DELETE, ROLLBACK ON ").append(StringUtils.quoteIdentifier(string)).append('.').append(StringUtils.quoteIdentifier(string2)).append(" FOR EACH ROW CALL \"").append(FullTextTrigger.class.getName()).append("\"");
        statement.execute(stringBuilder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static IndexModifier getIndexModifier(Connection connection) throws SQLException {
        IndexModifier indexModifier;
        String string = FullTextLucene.getIndexPath(connection);
        HashMap<String, IndexModifier> hashMap = INDEX_MODIFIERS;
        synchronized (hashMap) {
            indexModifier = INDEX_MODIFIERS.get(string);
            if (indexModifier == null) {
                try {
                    boolean bl = !IndexReader.indexExists((String)string);
                    StandardAnalyzer standardAnalyzer = new StandardAnalyzer();
                    indexModifier = new IndexModifier(string, (Analyzer)standardAnalyzer, bl);
                }
                catch (IOException iOException) {
                    throw FullTextLucene.convertException(iOException);
                }
                INDEX_MODIFIERS.put(string, indexModifier);
            }
        }
        return indexModifier;
    }

    protected static String getIndexPath(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("CALL DATABASE_PATH()");
        resultSet.next();
        String string = resultSet.getString(1);
        if (string == null) {
            throw FullTextLucene.throwException("Fulltext search for in-memory databases is not supported.");
        }
        int n = string.lastIndexOf(58);
        if (n > 1) {
            string = string.substring(n + 1);
        }
        resultSet.close();
        return string;
    }

    protected static void indexExistingRows(Connection connection, String string, String string2) throws SQLException {
        FullTextTrigger fullTextTrigger = new FullTextTrigger();
        fullTextTrigger.init(connection, string, null, string2, false, 1);
        String string3 = "SELECT * FROM " + StringUtils.quoteIdentifier(string) + "." + StringUtils.quoteIdentifier(string2);
        ResultSet resultSet = connection.createStatement().executeQuery(string3);
        int n = resultSet.getMetaData().getColumnCount();
        while (resultSet.next()) {
            Object[] objectArray = new Object[n];
            for (int i = 0; i < n; ++i) {
                objectArray[i] = resultSet.getObject(i + 1);
            }
            fullTextTrigger.fire(connection, null, objectArray);
        }
    }

    private static void removeIndexFiles(Connection connection) throws SQLException {
        String string = FullTextLucene.getIndexPath(connection);
        IndexModifier indexModifier = INDEX_MODIFIERS.get(string);
        if (indexModifier != null) {
            FullTextLucene.removeIndexModifier(indexModifier, string);
        }
        FileSystem.getInstance(string).deleteRecursive(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeIndexModifier(IndexModifier indexModifier, String string) throws SQLException {
        HashMap<String, IndexModifier> hashMap = INDEX_MODIFIERS;
        synchronized (hashMap) {
            try {
                INDEX_MODIFIERS.remove(string);
                indexModifier.flush();
                indexModifier.close();
            }
            catch (Exception exception) {
                throw FullTextLucene.convertException(exception);
            }
        }
    }

    protected static ResultSet search(Connection connection, String string, int n, int n2, boolean bl) throws SQLException {
        SimpleResultSet simpleResultSet = FullTextLucene.createResultSet(bl);
        if (connection.getMetaData().getURL().startsWith("jdbc:columnlist:")) {
            return simpleResultSet;
        }
        if (string == null || string.trim().length() == 0) {
            return simpleResultSet;
        }
        String string2 = FullTextLucene.getIndexPath(connection);
        try {
            IndexModifier indexModifier = FullTextLucene.getIndexModifier(connection);
            indexModifier.flush();
            IndexReader indexReader = IndexReader.open((String)string2);
            StandardAnalyzer standardAnalyzer = new StandardAnalyzer();
            IndexSearcher indexSearcher = new IndexSearcher(indexReader);
            QueryParser queryParser = new QueryParser(LUCENE_FIELD_DATA, (Analyzer)standardAnalyzer);
            Query query = queryParser.parse(string);
            Hits hits = indexSearcher.search(query);
            int n3 = hits.length();
            if (n == 0) {
                n = n3;
            }
            for (int i = 0; i < n && i + n2 < n3; ++i) {
                Document document = hits.doc(i + n2);
                float f = hits.score(i + n2);
                String string3 = document.get(LUCENE_FIELD_QUERY);
                if (bl) {
                    int n4 = string3.indexOf(" WHERE ");
                    JdbcConnection jdbcConnection = (JdbcConnection)connection;
                    Session session = (Session)jdbcConnection.getSession();
                    Parser parser = new Parser(session);
                    String string4 = string3.substring(0, n4);
                    ExpressionColumn expressionColumn = (ExpressionColumn)parser.parseExpression(string4);
                    String string5 = expressionColumn.getOriginalTableAliasName();
                    String string6 = expressionColumn.getColumnName();
                    string3 = string3.substring(n4 + " WHERE ".length());
                    Object[][] objectArray = FullTextLucene.parseKey(connection, string3);
                    simpleResultSet.addRow(string5, string6, objectArray[0], objectArray[1], Float.valueOf(f));
                    continue;
                }
                simpleResultSet.addRow(string3, Float.valueOf(f));
            }
            indexReader.close();
        }
        catch (Exception exception) {
            throw FullTextLucene.convertException(exception);
        }
        return simpleResultSet;
    }

    public static class FullTextTrigger
    implements Trigger {
        protected String schema;
        protected String table;
        protected int[] keys;
        protected int[] indexColumns;
        protected String[] columns;
        protected int[] columnTypes;
        protected String indexPath;
        protected IndexModifier indexModifier;

        public void init(Connection connection, String string, String string2, String string3, boolean bl, int n) throws SQLException {
            String string4;
            this.schema = string;
            this.table = string3;
            this.indexPath = FullTextLucene.getIndexPath(connection);
            this.indexModifier = FullTextLucene.getIndexModifier(connection);
            ArrayList<String> arrayList = New.arrayList();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ResultSet resultSet = databaseMetaData.getColumns(null, JdbcUtils.escapeMetaDataPattern(string), JdbcUtils.escapeMetaDataPattern(string3), null);
            ArrayList<String> arrayList2 = New.arrayList();
            while (resultSet.next()) {
                arrayList2.add(resultSet.getString("COLUMN_NAME"));
            }
            this.columnTypes = new int[arrayList2.size()];
            this.columns = new String[arrayList2.size()];
            arrayList2.toArray(this.columns);
            resultSet = databaseMetaData.getColumns(null, JdbcUtils.escapeMetaDataPattern(string), JdbcUtils.escapeMetaDataPattern(string3), null);
            int n2 = 0;
            while (resultSet.next()) {
                this.columnTypes[n2] = resultSet.getInt("DATA_TYPE");
                ++n2;
            }
            if (arrayList.size() == 0) {
                resultSet = databaseMetaData.getPrimaryKeys(null, JdbcUtils.escapeMetaDataPattern(string), string3);
                while (resultSet.next()) {
                    arrayList.add(resultSet.getString("COLUMN_NAME"));
                }
            }
            if (arrayList.size() == 0) {
                throw FullText.throwException("No primary key for table " + string3);
            }
            ArrayList<String> arrayList3 = New.arrayList();
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT COLUMNS FROM FTL.INDEXES WHERE SCHEMA=? AND TABLE=?");
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string3);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next() && (string4 = resultSet.getString(1)) != null) {
                for (String string5 : StringUtils.arraySplit(string4, ',', true)) {
                    arrayList3.add(string5);
                }
            }
            if (arrayList3.size() == 0) {
                arrayList3.addAll(arrayList2);
            }
            this.keys = new int[arrayList.size()];
            FullText.setColumns(this.keys, arrayList, arrayList2);
            this.indexColumns = new int[arrayList3.size()];
            FullText.setColumns(this.indexColumns, arrayList3, arrayList2);
        }

        public void fire(Connection connection, Object[] objectArray, Object[] objectArray2) throws SQLException {
            if (objectArray != null) {
                if (objectArray2 != null) {
                    if (FullText.hasChanged(objectArray, objectArray2, this.indexColumns)) {
                        this.delete(objectArray);
                        this.insert(objectArray2);
                    }
                } else {
                    this.delete(objectArray);
                }
            } else if (objectArray2 != null) {
                this.insert(objectArray2);
            }
        }

        public void close() throws SQLException {
            if (this.indexModifier != null) {
                FullTextLucene.removeIndexModifier(this.indexModifier, this.indexPath);
                this.indexModifier = null;
            }
        }

        public void remove() {
        }

        protected void insert(Object[] objectArray) throws SQLException {
            String string = this.getQuery(objectArray);
            Document document = new Document();
            document.add((Fieldable)new Field(FullTextLucene.LUCENE_FIELD_QUERY, string, Field.Store.YES, Field.Index.UN_TOKENIZED));
            long l = System.currentTimeMillis();
            document.add((Fieldable)new Field(FullTextLucene.LUCENE_FIELD_MODIFIED, DateTools.timeToString((long)l, (DateTools.Resolution)DateTools.Resolution.SECOND), Field.Store.YES, Field.Index.UN_TOKENIZED));
            StatementBuilder statementBuilder = new StatementBuilder();
            for (int n : this.indexColumns) {
                String string2 = this.columns[n];
                String string3 = FullText.asString(objectArray[n], this.columnTypes[n]);
                if (string2.startsWith(FullTextLucene.LUCENE_FIELD_COLUMN_PREFIX)) {
                    string2 = FullTextLucene.LUCENE_FIELD_COLUMN_PREFIX + string2;
                }
                document.add((Fieldable)new Field(string2, string3, Field.Store.NO, Field.Index.TOKENIZED));
                statementBuilder.appendExceptFirst(" ");
                statementBuilder.append(string3);
            }
            Field.Store store = STORE_DOCUMENT_TEXT_IN_INDEX ? Field.Store.YES : Field.Store.NO;
            document.add((Fieldable)new Field(FullTextLucene.LUCENE_FIELD_DATA, statementBuilder.toString(), store, Field.Index.TOKENIZED));
            try {
                this.indexModifier.addDocument(document);
            }
            catch (IOException iOException) {
                throw FullTextLucene.convertException(iOException);
            }
        }

        protected void delete(Object[] objectArray) throws SQLException {
            String string = this.getQuery(objectArray);
            try {
                Term term = new Term(FullTextLucene.LUCENE_FIELD_QUERY, string);
                this.indexModifier.deleteDocuments(term);
            }
            catch (IOException iOException) {
                throw FullTextLucene.convertException(iOException);
            }
        }

        private String getQuery(Object[] objectArray) throws SQLException {
            StatementBuilder statementBuilder = new StatementBuilder();
            if (this.schema != null) {
                statementBuilder.append(StringUtils.quoteIdentifier(this.schema)).append('.');
            }
            statementBuilder.append(StringUtils.quoteIdentifier(this.table)).append(" WHERE ");
            for (int n : this.keys) {
                statementBuilder.appendExceptFirst(" AND ");
                statementBuilder.append(StringUtils.quoteIdentifier(this.columns[n]));
                Object object = objectArray[n];
                if (object == null) {
                    statementBuilder.append(" IS NULL");
                    continue;
                }
                statementBuilder.append('=').append(FullText.quoteSQL(object, this.columnTypes[n]));
            }
            return statementBuilder.toString();
        }
    }
}

