/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import org.h2.command.Parser;
import org.h2.engine.Database;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.Message;
import org.h2.table.Table;
import org.h2.util.ClassUtils;
import org.h2.util.ObjectArray;
import org.h2.util.StatementBuilder;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class FunctionAlias
extends DbObjectBase {
    private String className;
    private String methodName;
    private JavaMethod[] javaMethods;
    private boolean deterministic;

    public FunctionAlias(Database database, int n, String string, String string2, boolean bl) throws SQLException {
        block3: {
            this.initDbObjectBase(database, n, string, "function");
            int n2 = string2.indexOf(40);
            int n3 = string2.lastIndexOf(46, n2 < 0 ? string2.length() : n2);
            if (n3 < 0) {
                throw Message.getSQLException(42000, string2);
            }
            this.className = string2.substring(0, n3);
            this.methodName = string2.substring(n3 + 1);
            try {
                this.load();
            }
            catch (SQLException sQLException) {
                if (bl) break block3;
                throw sQLException;
            }
        }
    }

    private synchronized void load() throws SQLException {
        if (this.javaMethods != null) {
            return;
        }
        Class<?> clazz = ClassUtils.loadUserClass(this.className);
        Method[] methodArray = clazz.getMethods();
        ObjectArray<JavaMethod> objectArray = ObjectArray.newInstance();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!Modifier.isStatic(method.getModifiers()) || !method.getName().equals(this.methodName) && !this.getMethodSignature(method).equals(this.methodName)) continue;
            JavaMethod javaMethod = new JavaMethod(method, i);
            for (JavaMethod javaMethod2 : objectArray) {
                if (javaMethod2.getParameterCount() != javaMethod.getParameterCount()) continue;
                throw Message.getSQLException(90073, javaMethod2.toString(), javaMethod.toString());
            }
            objectArray.add(javaMethod);
        }
        if (objectArray.size() == 0) {
            throw Message.getSQLException(90139, this.methodName + " (" + this.className + ")");
        }
        this.javaMethods = new JavaMethod[objectArray.size()];
        objectArray.toArray(this.javaMethods);
        Arrays.sort(this.javaMethods);
    }

    private String getMethodSignature(Method method) {
        StatementBuilder statementBuilder = new StatementBuilder(method.getName());
        statementBuilder.append('(');
        for (Class<?> clazz : method.getParameterTypes()) {
            statementBuilder.appendExceptFirst(", ");
            if (clazz.isArray()) {
                statementBuilder.append(clazz.getComponentType().getName()).append("[]");
                continue;
            }
            statementBuilder.append(clazz.getName());
        }
        return statementBuilder.append(')').toString();
    }

    public String getCreateSQLForCopy(Table table, String string) {
        throw Message.throwInternalError();
    }

    public String getDropSQL() {
        return "DROP ALIAS IF EXISTS " + this.getSQL();
    }

    public String getCreateSQL() {
        StringBuilder stringBuilder = new StringBuilder("CREATE FORCE ALIAS ");
        stringBuilder.append(this.getSQL());
        if (this.deterministic) {
            stringBuilder.append(" DETERMINISTIC");
        }
        stringBuilder.append(" FOR ").append(Parser.quoteIdentifier(this.className + "." + this.methodName));
        return stringBuilder.toString();
    }

    public int getType() {
        return 9;
    }

    public synchronized void removeChildrenAndResources(Session session) throws SQLException {
        this.database.removeMeta(session, this.getId());
        this.className = null;
        this.methodName = null;
        this.javaMethods = null;
        this.invalidate();
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException("RENAME");
    }

    public JavaMethod findJavaMethod(Expression[] expressionArray) throws SQLException {
        this.load();
        int n = expressionArray.length;
        for (JavaMethod javaMethod : this.javaMethods) {
            int n2 = javaMethod.getParameterCount();
            if (n2 != n && (!javaMethod.isVarArgs() || n2 > n + 1)) continue;
            return javaMethod;
        }
        throw Message.getSQLException(90087, this.methodName + " (" + this.className + ", parameter count: " + n + ")");
    }

    public String getJavaClassName() {
        return this.className;
    }

    public String getJavaMethodName() {
        return this.methodName;
    }

    public JavaMethod[] getJavaMethods() throws SQLException {
        this.load();
        return this.javaMethods;
    }

    public void setDeterministic(boolean bl) {
        this.deterministic = bl;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JavaMethod
    implements Comparable<JavaMethod> {
        private final int id;
        private final Method method;
        private final int dataType;
        private boolean hasConnectionParam;
        private boolean varArgs;
        private Class<?> varArgClass;
        private int paramCount;

        JavaMethod(Method method, int n) throws SQLException {
            Class<?> clazz;
            this.method = method;
            this.id = n;
            Class<?>[] classArray = method.getParameterTypes();
            this.paramCount = classArray.length;
            if (this.paramCount > 0 && Connection.class.isAssignableFrom(clazz = classArray[0])) {
                this.hasConnectionParam = true;
                --this.paramCount;
            }
            if (this.paramCount > 0 && (clazz = classArray[classArray.length - 1]).isArray() && ClassUtils.isVarArgs(method)) {
                this.varArgs = true;
                this.varArgClass = clazz.getComponentType();
            }
            clazz = method.getReturnType();
            this.dataType = DataType.getTypeFromClass(clazz);
        }

        public String toString() {
            return this.method.toString();
        }

        public boolean hasConnectionParam() {
            return this.hasConnectionParam;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Value getValue(Session session, Expression[] expressionArray, boolean bl) throws SQLException {
            Class<?> clazz;
            int n;
            Class<?>[] classArray = this.method.getParameterTypes();
            Object[] objectArray = new Object[classArray.length];
            int n2 = 0;
            if (this.hasConnectionParam && objectArray.length > 0) {
                objectArray[n2++] = session.createConnection(bl);
            }
            Object object = null;
            if (this.varArgs) {
                n = expressionArray.length - objectArray.length + 1 + (this.hasConnectionParam ? 1 : 0);
                objectArray[objectArray.length - 1] = object = Array.newInstance(this.varArgClass, n);
            }
            n = 0;
            while (n < expressionArray.length) {
                boolean bl2 = this.varArgs && n2 >= classArray.length - 1;
                clazz = bl2 ? this.varArgClass : classArray[n2];
                int n3 = DataType.getTypeFromClass(clazz);
                Value value = expressionArray[n].getValue(session);
                Object object2 = (value = value.convertTo(n3)).getObject();
                if (object2 == null) {
                    if (clazz.isPrimitive()) {
                        if (!bl) return ValueNull.INSTANCE;
                        object2 = DataType.getDefaultForPrimitiveType(clazz);
                    }
                } else if (!clazz.isAssignableFrom(object2.getClass()) && !clazz.isPrimitive()) {
                    object2 = DataType.convertTo(session, session.createConnection(false), value, clazz);
                }
                if (bl2) {
                    Array.set(object, n2 - objectArray.length + 1, object2);
                } else {
                    objectArray[n2] = object2;
                }
                ++n;
                ++n2;
            }
            n = session.getAutoCommit() ? 1 : 0;
            try {
                Object object3;
                block16: {
                    session.setAutoCommit(false);
                    try {
                        object3 = this.method.invoke(null, objectArray);
                        if (object3 != null) break block16;
                        clazz = ValueNull.INSTANCE;
                        return clazz;
                    }
                    catch (Exception exception) {
                        throw Message.convert(exception);
                    }
                }
                clazz = DataType.convertToValue(session, object3, this.dataType);
                Value value = ((Value)((Object)clazz)).convertTo(this.dataType);
                return value;
            }
            finally {
                session.setAutoCommit(n != 0);
            }
        }

        public Class<?>[] getColumnClasses() {
            return this.method.getParameterTypes();
        }

        public int getDataType() {
            return this.dataType;
        }

        public int getParameterCount() {
            return this.paramCount;
        }

        public boolean isVarArgs() {
            return this.varArgs;
        }

        @Override
        public int compareTo(JavaMethod javaMethod) {
            if (this.varArgs != javaMethod.varArgs) {
                return this.varArgs ? 1 : -1;
            }
            if (this.paramCount != javaMethod.paramCount) {
                return this.paramCount - javaMethod.paramCount;
            }
            if (this.hasConnectionParam != javaMethod.hasConnectionParam) {
                return this.hasConnectionParam ? 1 : -1;
            }
            return this.id - javaMethod.id;
        }
    }
}

