/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import proguard.io.DataEntry;
import proguard.io.DataEntryReader;
import proguard.io.FileDataEntry;
import proguard.io.JarReader;
import proguard.io.ZipFileDataEntry;
import proguard.util.FileNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;

public class PrioritizingJarReader
extends JarReader {
    private final DataEntryReader dataEntryReader;
    private final Map<StringMatcher, Integer> matcherToPriorityMap = new HashMap<StringMatcher, Integer>();

    public PrioritizingJarReader(Map<String, Integer> priorityMap, DataEntryReader dataEntryReader) {
        this(priorityMap, false, dataEntryReader);
    }

    public PrioritizingJarReader(Map<String, Integer> priorityMap, boolean jmod, DataEntryReader dataEntryReader) {
        super(jmod, dataEntryReader);
        this.dataEntryReader = dataEntryReader;
        priorityMap.forEach((filter, priority) -> this.matcherToPriorityMap.put(new ListParser(new FileNameParser()).parse((String)filter), (Integer)priority));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(DataEntry dataEntry) throws IOException {
        if (dataEntry instanceof FileDataEntry) {
            FileDataEntry fileDataEntry = (FileDataEntry)dataEntry;
            try (ZipFile zipFile = new ZipFile(fileDataEntry.getFile(), StandardCharsets.UTF_8);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                ArrayList<ComparableZipEntry> orderedZipEntryList = new ArrayList<ComparableZipEntry>();
                while (entries.hasMoreElements()) {
                    ZipEntry zipEntry = entries.nextElement();
                    orderedZipEntryList.add(new ComparableZipEntry(zipEntry, this.getPriority(zipEntry)));
                }
                Collections.sort(orderedZipEntryList);
                for (ComparableZipEntry entry : orderedZipEntryList) {
                    this.dataEntryReader.read(new ZipFileDataEntry(dataEntry, entry.getZipEntry(), zipFile));
                }
            }
        } else {
            super.read(dataEntry);
        }
    }

    private int getPriority(ZipEntry zipEntry) {
        int priority = Integer.MAX_VALUE;
        boolean matched = false;
        for (Map.Entry<StringMatcher, Integer> entry : this.matcherToPriorityMap.entrySet()) {
            if (!entry.getKey().matches(zipEntry.getName()) || entry.getValue() >= priority) continue;
            matched = true;
            priority = entry.getValue();
        }
        return matched ? priority : 0;
    }

    private static class ComparableZipEntry
    implements Comparable<ComparableZipEntry> {
        private final ZipEntry zipEntry;
        private final int priority;

        public ComparableZipEntry(ZipEntry zipEntry, int priority) {
            this.zipEntry = zipEntry;
            this.priority = priority;
        }

        public ZipEntry getZipEntry() {
            return this.zipEntry;
        }

        @Override
        public int compareTo(@NotNull ComparableZipEntry other) {
            return Integer.compare(this.priority, other.priority);
        }
    }
}

