/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value.object;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import proguard.evaluation.value.object.AnalyzedObject;
import proguard.evaluation.value.object.model.Model;

class ModeledObject
implements AnalyzedObject {
    private final Model value;

    ModeledObject(Model value) {
        this.value = value;
    }

    @Override
    @NotNull
    public Model getModeledValue() {
        return this.value;
    }

    @Override
    @NotNull
    public String getType() {
        return this.value.getType();
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isModeled() {
        return true;
    }

    @Override
    public boolean isPrecise() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModeledObject)) {
            return false;
        }
        ModeledObject that = (ModeledObject)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return String.format("ModeledObject(%s)", this.value);
    }
}

