/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.util.jsonprinter;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import proguard.evaluation.util.jsonprinter.BranchTargetRecord;
import proguard.evaluation.util.jsonprinter.ExceptionHandlerRecord;
import proguard.evaluation.util.jsonprinter.InstructionEvaluationRecord;
import proguard.evaluation.util.jsonprinter.JsonPrinter;
import proguard.evaluation.util.jsonprinter.JsonSerializable;

class InstructionBlockEvaluationRecord
implements JsonSerializable {
    @NotNull
    private final List<InstructionEvaluationRecord> evaluations = new ArrayList<InstructionEvaluationRecord>();
    private final ExceptionHandlerRecord exceptionHandlerInfo;
    private List<String> startVariables;
    private List<String> startStack;
    private final int startOffset;
    @NotNull
    private final List<BranchTargetRecord> branchEvaluationStack;

    public InstructionBlockEvaluationRecord(List<String> startVariables, List<String> startStack, int startOffset, ExceptionHandlerRecord exceptionHandlerInfo, @NotNull List<BranchTargetRecord> branchEvaluationStack) {
        this.startVariables = startVariables;
        this.startStack = startStack;
        this.startOffset = startOffset;
        this.exceptionHandlerInfo = exceptionHandlerInfo;
        this.branchEvaluationStack = branchEvaluationStack;
    }

    @Override
    public StringBuilder toJson(StringBuilder builder) {
        builder.append("{");
        JsonPrinter.toJson("startOffset", this.startOffset, builder).append(",");
        JsonPrinter.listToJson("evaluations", this.evaluations, builder).append(",");
        JsonPrinter.listToJson("branchEvaluationStack", this.branchEvaluationStack, builder);
        if (this.exceptionHandlerInfo != null) {
            builder.append(",");
            JsonPrinter.serializeJsonSerializable("exceptionHandlerInfo", this.exceptionHandlerInfo, builder);
        }
        if (this.startVariables != null) {
            builder.append(",");
            JsonPrinter.stringListToJson("startVariables", this.startVariables, builder);
        }
        if (this.startStack != null) {
            builder.append(",");
            JsonPrinter.stringListToJson("startStack", this.startStack, builder);
        }
        return builder.append("}");
    }

    public void setStartVariables(List<String> startVariables) {
        this.startVariables = startVariables;
    }

    public void setStartStack(List<String> startStack) {
        this.startStack = startStack;
    }

    public InstructionEvaluationRecord getLastInstructionEvaluation() {
        if (this.evaluations.isEmpty()) {
            return null;
        }
        return this.evaluations.get(this.evaluations.size() - 1);
    }

    @NotNull
    public List<InstructionEvaluationRecord> getEvaluations() {
        return this.evaluations;
    }

    public ExceptionHandlerRecord getExceptionHandlerInfo() {
        return this.exceptionHandlerInfo;
    }

    public List<String> getStartVariables() {
        return this.startVariables;
    }

    public List<String> getStartStack() {
        return this.startStack;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    @NotNull
    public List<BranchTargetRecord> getBranchEvaluationStack() {
        return this.branchEvaluationStack;
    }
}

