/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.executor;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import proguard.classfile.Clazz;
import proguard.classfile.MethodInfo;
import proguard.classfile.MethodSignature;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InitializedClassUtil;
import proguard.evaluation.MethodResult;
import proguard.evaluation.ValueCalculator;
import proguard.evaluation.executor.Executor;
import proguard.evaluation.executor.MethodExecutionInfo;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TypedReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.object.AnalyzedObject;
import proguard.evaluation.value.object.model.Model;
import proguard.evaluation.value.object.model.reflective.ModelHelper;
import proguard.evaluation.value.object.model.reflective.ReflectiveModel;
import proguard.util.HierarchyProvider;

public class ReflectiveModelExecutor
implements Executor {
    private static final Logger log = LogManager.getLogger(ReflectiveModelExecutor.class);
    protected final Set<SupportedModelInfo<? extends ReflectiveModel<?>>> supportedModels;
    protected final Set<MethodSignature> supportedSignatures;
    protected final Map<MethodSignature, Class<? extends ReflectiveModel<?>>> supportedSignatureToModel;

    protected ReflectiveModelExecutor(Set<SupportedModelInfo<?>> supportedModels, HierarchyProvider hierarchy) {
        this.supportedModels = supportedModels;
        HashSet supportedSignaturesMutable = new HashSet();
        HashMap supportedSignatureToModelMutable = new HashMap();
        for (SupportedModelInfo<?> modelInfo : supportedModels) {
            ReflectiveModelExecutor.generateMethodSignaturesForModel(modelInfo, hierarchy).forEach(signature -> {
                supportedSignaturesMutable.add(signature);
                supportedSignatureToModelMutable.put(signature, modelInfo.getModelClass());
            });
        }
        this.supportedSignatures = Collections.unmodifiableSet(supportedSignaturesMutable);
        this.supportedSignatureToModel = Collections.unmodifiableMap(supportedSignatureToModelMutable);
    }

    @Override
    public MethodResult getMethodResult(MethodExecutionInfo methodExecutionInfo, ValueCalculator valueCalculator) {
        this.checkInstanceSanity(methodExecutionInfo, this.supportedSignatureToModel);
        if (!this.canExecuteWithInstance(methodExecutionInfo)) {
            return MethodResult.invalidResult();
        }
        this.checkParameterSanity(methodExecutionInfo, this.supportedSignatureToModel);
        Object instanceModel = this.getInstanceModel(methodExecutionInfo);
        return this.execute(methodExecutionInfo, valueCalculator, (Model)instanceModel);
    }

    private <T extends ReflectiveModel<T>> T getInstanceModel(MethodExecutionInfo methodExecutionInfo) {
        ReflectiveModel<?> instanceModel;
        boolean isInstanceParticular;
        ReferenceValue callingInstance = methodExecutionInfo.getInstanceOrNullIfStatic();
        boolean bl = isInstanceParticular = callingInstance != null && callingInstance.isParticular();
        if (methodExecutionInfo.isConstructor() || methodExecutionInfo.isStatic() || !isInstanceParticular) {
            Class<? extends ReflectiveModel<?>> targetClass = Objects.requireNonNull(this.supportedSignatureToModel.get(methodExecutionInfo.getResolvedTargetSignature()), "The target signature has been already checked to be supported");
            instanceModel = ModelHelper.getDummyObject(targetClass);
        } else {
            instanceModel = (ReflectiveModel<?>)Objects.requireNonNull(callingInstance).getValue().getModeledValue();
        }
        return (T)instanceModel;
    }

    private MethodResult execute(MethodExecutionInfo methodExecutionInfo, ValueCalculator valueCalculator, Model instanceModel) {
        if (methodExecutionInfo.isConstructor()) {
            return instanceModel.init(methodExecutionInfo, valueCalculator);
        }
        if (methodExecutionInfo.isStatic()) {
            return instanceModel.invokeStatic(methodExecutionInfo, valueCalculator);
        }
        return instanceModel.invoke(methodExecutionInfo, valueCalculator);
    }

    @Override
    public Set<MethodSignature> getSupportedMethodSignatures() {
        return this.supportedSignatures;
    }

    private void checkInstanceSanity(MethodExecutionInfo methodInfo, Map<MethodSignature, Class<? extends ReflectiveModel<?>>> supportedSignatureToModel) {
        ReferenceValue instanceValue = methodInfo.getInstanceOrNullIfStatic();
        if (methodInfo.isStatic() && instanceValue != null) {
            throw new IllegalStateException("No instance expected for static methods.");
        }
        if (methodInfo.isStatic()) {
            return;
        }
        if (instanceValue == null) {
            throw new IllegalStateException("Unexpected null instance value for an instance method.");
        }
        if (instanceValue.isParticular() && instanceValue.getValue().isNull()) {
            return;
        }
        if (instanceValue.isParticular()) {
            ReferenceValue instanceReferenceValue = instanceValue.referenceValue();
            if (!instanceReferenceValue.getValue().isModeled()) {
                throw new IllegalStateException("Should not use ReflectiveModelExecutor on non-model instances, are you sure you are matching the expected executor?");
            }
            this.checkArgumentCorrectModel(instanceReferenceValue.getValue(), supportedSignatureToModel);
        }
    }

    private boolean canExecuteWithInstance(MethodExecutionInfo methodInfo) {
        if (methodInfo.isStatic()) {
            return true;
        }
        ReferenceValue instanceValue = methodInfo.getInstanceNonStatic();
        if (methodInfo.isConstructor()) {
            return instanceValue.isSpecific();
        }
        return !instanceValue.isParticular() || !instanceValue.getValue().isNull();
    }

    private void checkParameterSanity(MethodExecutionInfo executionInfo, Map<MethodSignature, Class<? extends ReflectiveModel<?>>> supportedSignatureToModel) {
        List<Value> parameters = executionInfo.getParameters();
        List<String> parameterTypes = executionInfo.getSignature().descriptor.getArgumentTypes();
        if (parameterTypes.size() != parameters.size()) {
            throw new IllegalStateException("The number of provided parameters is different from the number of parameters specified in the called method signature");
        }
        for (int i = 0; i < parameters.size(); ++i) {
            Value parameter = parameters.get(i);
            String staticType = parameterTypes.get(i);
            Clazz parameterClass = executionInfo.getParametersClasses().get(i);
            this.checkParameter(staticType, parameter, parameterClass, supportedSignatureToModel);
        }
    }

    private void checkParameter(String staticType, Value parameter, Clazz parameterClass, Map<MethodSignature, Class<? extends ReflectiveModel<?>>> supportedSignatureToModel) {
        if (ClassUtil.isInternalPrimitiveType(staticType)) {
            if (ClassUtil.internalPrimitiveTypeToComputationalType(staticType) != ClassUtil.internalPrimitiveTypeToComputationalType(parameter.internalType())) {
                throw new IllegalStateException(String.format("The parameter should be primitive, but the computational type of \"%s\" and \"%s\" do not correspond", parameter.internalType(), staticType));
            }
        } else {
            ReferenceValue parameterValue = parameter.referenceValue();
            String parameterType = parameterValue.getType();
            if (parameterType == null || parameterValue.isParticular() && parameterValue.getValue().isNull() || !(parameterValue instanceof TypedReferenceValue)) {
                return;
            }
            if (this.isParameterTypeInvalid(parameterType, parameterClass, staticType)) {
                throw new IllegalStateException(String.format("Parameter type is \"%s\", which does not match or inherit from the static type \"%s\"", parameterType, staticType));
            }
            if (parameterValue.isParticular() && parameterValue.getValue().isModeled()) {
                this.checkArgumentCorrectModel(parameterValue.getValue(), supportedSignatureToModel);
            }
        }
    }

    private boolean isParameterTypeInvalid(String parameterType, Clazz parameterClass, String staticType) {
        return !parameterType.equals(staticType) && parameterClass != null && !InitializedClassUtil.isInstanceOf(parameterType, parameterClass);
    }

    private void checkArgumentCorrectModel(AnalyzedObject parameterObject, Map<MethodSignature, Class<? extends ReflectiveModel<?>>> supportedSignatureToModel) {
        for (Map.Entry<MethodSignature, Class<ReflectiveModel<?>>> entry : supportedSignatureToModel.entrySet()) {
            if (!this.isArgumentWrongModel(entry.getKey(), entry.getValue(), parameterObject.getType(), parameterObject.getModeledValue())) continue;
            throw new IllegalArgumentException(String.format("The parameter is of the type supported by ReflectiveModelExecutor \"%s\", but the model is of class \"%s\" instead of the model expected by the executor \"%s\"", entry.getKey(), parameterObject.getModeledValue().getClass(), supportedSignatureToModel.get(entry.getKey())));
        }
    }

    private boolean isArgumentWrongModel(MethodSignature supportedSignature, Class<?> supportedModel, @Nullable String parameterType, Model parameterModel) {
        return ClassUtil.internalTypeFromClassName(supportedSignature.getClassName()).equals(parameterType) && !supportedModel.isInstance(parameterModel);
    }

    public static <T extends ReflectiveModel<T>> Set<MethodSignature> generateMethodSignaturesForModel(SupportedModelInfo<T> modelInfo, HierarchyProvider hierarchy) {
        Object dummy = ModelHelper.getDummyObject(((SupportedModelInfo)modelInfo).modelClass);
        String className = ClassUtil.internalClassNameFromType(dummy.getType());
        Clazz clazz = hierarchy.getClazz(className);
        if (clazz == null) {
            log.info("The class hierarchy does not contain {}, the executor won't be able to execute methods from it", (Object)className);
            return Collections.emptySet();
        }
        if ((clazz.getAccessFlags() & 0x200) != 0) {
            log.error("This method has been designed for classes, if it needs to be called for an interface explicit support should be added");
            return Collections.emptySet();
        }
        HashSet<MethodSignature> supportedMethods = new HashSet<MethodSignature>();
        for (MethodInfo methodInfo : ModelHelper.getSupportedMethods(((SupportedModelInfo)modelInfo).modelClass)) {
            if (((SupportedModelInfo)modelInfo).supportsFullInheritance) {
                for (String subClassName : hierarchy.getSubClasses(className)) {
                    MethodSignature signature = new MethodSignature(subClassName, methodInfo.getMethodName(), methodInfo.getDescriptor());
                    supportedMethods.add(signature);
                }
            }
            MethodSignature signature = new MethodSignature(className, methodInfo.getMethodName(), methodInfo.getDescriptor());
            supportedMethods.add(signature);
        }
        return supportedMethods;
    }

    public static class Builder
    implements Executor.Builder<ReflectiveModelExecutor> {
        private final Set<SupportedModelInfo<? extends ReflectiveModel<?>>> supportedModels = new HashSet();
        private final HierarchyProvider hierarchy;

        public Builder(HierarchyProvider hierarchy) {
            this.hierarchy = hierarchy;
        }

        public <T extends ReflectiveModel<T>> Builder addSupportedModel(SupportedModelInfo<T> modelInfo) {
            this.supportedModels.add(modelInfo);
            return this;
        }

        public Builder addSupportedModels(Collection<SupportedModelInfo<? extends ReflectiveModel<?>>> modelInfo) {
            this.supportedModels.addAll(modelInfo);
            return this;
        }

        @Override
        public ReflectiveModelExecutor build() {
            return new ReflectiveModelExecutor(this.supportedModels, this.hierarchy);
        }
    }

    public static final class SupportedModelInfo<T extends ReflectiveModel<T>> {
        private final Class<T> modelClass;
        private final boolean supportsFullInheritance;

        public SupportedModelInfo(Class<T> modelClass, boolean supportsFullInheritance) {
            this.modelClass = modelClass;
            this.supportsFullInheritance = supportsFullInheritance;
        }

        public Class<T> getModelClass() {
            return this.modelClass;
        }

        public boolean isSupportsFullInheritance() {
            return this.supportsFullInheritance;
        }
    }
}

