/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import java.util.Set;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.visitor.MemberVisitor;

public class MemberCollectionFilter
implements MemberVisitor {
    private final Set<? extends Member> members;
    private final MemberVisitor acceptedVisitor;
    private final MemberVisitor rejectedVisitor;

    public MemberCollectionFilter(Set<? extends Member> members, MemberVisitor acceptedVisitor) {
        this(members, acceptedVisitor, null);
    }

    public MemberCollectionFilter(Set<? extends Member> members, MemberVisitor acceptedVisitor, MemberVisitor rejectedVisitor) {
        this.members = members;
        this.acceptedVisitor = acceptedVisitor;
        this.rejectedVisitor = rejectedVisitor;
    }

    @Override
    public void visitAnyMember(Clazz clazz, Member member) {
        MemberVisitor delegateVisitor = this.delegateVisitor(member);
        if (delegateVisitor != null) {
            member.accept(clazz, delegateVisitor);
        }
    }

    private MemberVisitor delegateVisitor(Member member) {
        return this.members.contains(member) ? this.acceptedVisitor : this.rejectedVisitor;
    }
}

