/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import java.util.HashMap;
import java.util.Map;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMember;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class StringSharer
implements ClassVisitor,
MemberVisitor,
ConstantVisitor,
AttributeVisitor,
KotlinMetadataVisitor {
    private final Map<String, String> stringPool;

    public StringSharer() {
        this.stringPool = new HashMap<String, String>();
    }

    public StringSharer(int initialStringPoolCapacity) {
        this.stringPool = new HashMap<String, String>(initialStringPoolCapacity);
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.constantPoolEntriesAccept(this);
        programClass.kotlinMetadataAccept(this);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        libraryClass.superClassName = this.getFromStringPool(libraryClass.superClassName);
        if (libraryClass.interfaceNames != null) {
            String[] interfaceNames = libraryClass.interfaceNames;
            for (int index = 0; index < interfaceNames.length; ++index) {
                interfaceNames[index] = this.getFromStringPool(interfaceNames[index]);
            }
        }
        libraryClass.fieldsAccept(this);
        libraryClass.methodsAccept(this);
        libraryClass.kotlinMetadataAccept(this);
    }

    @Override
    public void visitLibraryMember(LibraryClass libraryClass, LibraryMember libraryMember) {
        libraryMember.name = this.getFromStringPool(libraryMember.name);
        libraryMember.descriptor = this.getFromStringPool(libraryMember.descriptor);
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        utf8Constant.setString(this.getFromStringPool(utf8Constant.getString()));
    }

    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
    }

    @Override
    public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
        kotlinClassKindMetadata.className = this.getFromStringPool(kotlinClassKindMetadata.className);
        kotlinClassKindMetadata.companionObjectName = this.getFromStringPool(kotlinClassKindMetadata.companionObjectName);
        kotlinClassKindMetadata.anonymousObjectOriginName = this.getFromStringPool(kotlinClassKindMetadata.anonymousObjectOriginName);
    }

    private String getFromStringPool(String newString) {
        String existingString = this.stringPool.putIfAbsent(newString, newString);
        return existingString != null ? existingString : newString;
    }
}

