/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.signature.ast.signature;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import proguard.classfile.attribute.signature.ast.ASTStructureException;
import proguard.classfile.attribute.signature.ast.signature.ResultNode;
import proguard.classfile.attribute.signature.ast.signature.ThrowsSignatureNode;
import proguard.classfile.attribute.signature.ast.signature.TypeParameterNode;
import proguard.classfile.attribute.signature.ast.signature.TypeSignatureNode;
import proguard.classfile.attribute.signature.ast.visitor.ASTNodeVisitor;

public class MethodSignatureNode {
    @NotNull
    private List<TypeParameterNode> typeParameters;
    @NotNull
    private List<TypeSignatureNode> argumentTypes;
    @NotNull
    private ResultNode result;
    @NotNull
    private List<ThrowsSignatureNode> throwsSignatures;

    public MethodSignatureNode(@NotNull List<TypeParameterNode> typeParameters, @NotNull List<TypeSignatureNode> argumentTypes, @NotNull ResultNode result, @NotNull List<ThrowsSignatureNode> throwsSignatures) {
        if (typeParameters == null || argumentTypes == null || result == null || throwsSignatures == null) {
            throw new ASTStructureException("Arguments must no be null");
        }
        this.typeParameters = typeParameters;
        this.argumentTypes = argumentTypes;
        this.result = result;
        this.throwsSignatures = throwsSignatures;
    }

    @NotNull
    public List<TypeParameterNode> getTypeParameters() {
        return this.typeParameters;
    }

    public void setTypeParameters(@NotNull List<TypeParameterNode> typeParameters) {
        if (typeParameters == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.typeParameters = typeParameters;
    }

    @NotNull
    public List<TypeSignatureNode> getArgumentTypes() {
        return this.argumentTypes;
    }

    public void setArgumentTypes(@NotNull List<TypeSignatureNode> argumentTypes) {
        if (argumentTypes == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.argumentTypes = argumentTypes;
    }

    @NotNull
    public ResultNode getResult() {
        return this.result;
    }

    public void setResult(@NotNull ResultNode result) {
        if (result == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.result = result;
    }

    @NotNull
    public List<ThrowsSignatureNode> getThrowsSignatures() {
        return this.throwsSignatures;
    }

    public void setThrowsSignatures(@NotNull List<ThrowsSignatureNode> throwsSignatures) {
        if (throwsSignatures == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.throwsSignatures = throwsSignatures;
    }

    public <R, P> R accept(ASTNodeVisitor<R, P> visitor, P arg) {
        return visitor.visit(this, arg);
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.typeParameters.isEmpty()) {
            sb.append('<');
            for (TypeParameterNode typeParameterNode : this.typeParameters) {
                sb.append(typeParameterNode.toString());
            }
            sb.append('>');
        }
        sb.append('(');
        for (TypeSignatureNode argumentType : this.argumentTypes) {
            sb.append(argumentType);
        }
        sb.append(')');
        sb.append(this.result.toString());
        for (ThrowsSignatureNode throwsSignatureNode : this.throwsSignatures) {
            sb.append(throwsSignatureNode.toString());
        }
        return sb.toString();
    }
}

