/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.signature.ast.descriptor;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.classfile.attribute.signature.ast.ASTStructureException;
import proguard.classfile.attribute.signature.ast.descriptor.ArrayTypeNode;
import proguard.classfile.attribute.signature.ast.descriptor.BaseTypeNode;
import proguard.classfile.attribute.signature.ast.descriptor.ClassTypeNode;
import proguard.classfile.attribute.signature.ast.visitor.ASTNodeVisitor;

public class FieldTypeNode {
    @Nullable
    private BaseTypeNode baseType;
    @Nullable
    private ClassTypeNode classType;
    @Nullable
    private ArrayTypeNode arrayType;

    public FieldTypeNode(@NotNull BaseTypeNode type) {
        if (type == null) {
            throw new ASTStructureException("Argument must not be null");
        }
        this.baseType = type;
        this.classType = null;
        this.arrayType = null;
    }

    public FieldTypeNode(@NotNull ClassTypeNode type) {
        if (type == null) {
            throw new ASTStructureException("Argument must not be null");
        }
        this.classType = type;
        this.baseType = null;
        this.arrayType = null;
    }

    public FieldTypeNode(@NotNull ArrayTypeNode type) {
        if (type == null) {
            throw new ASTStructureException("Argument must not be null");
        }
        this.arrayType = type;
        this.baseType = null;
        this.classType = null;
    }

    public boolean isBaseType() {
        return this.baseType != null;
    }

    @Nullable
    public BaseTypeNode getBaseType() {
        return this.baseType;
    }

    public void changeToBaseType(@NotNull BaseTypeNode type) {
        if (type == null) {
            throw new ASTStructureException("Argument must not be null");
        }
        this.baseType = type;
        this.classType = null;
        this.arrayType = null;
    }

    public boolean isClassType() {
        return this.classType != null;
    }

    @Nullable
    public ClassTypeNode getClassType() {
        return this.classType;
    }

    public void changeToClassType(@NotNull ClassTypeNode type) {
        if (type == null) {
            throw new ASTStructureException("Argument must not be null");
        }
        this.classType = type;
        this.arrayType = null;
        this.baseType = null;
    }

    public boolean isArrayType() {
        return this.arrayType != null;
    }

    @Nullable
    public ArrayTypeNode getArrayType() {
        return this.arrayType;
    }

    public void changeToArrayType(@NotNull ArrayTypeNode type) {
        if (type == null) {
            throw new ASTStructureException("Argument must not be null");
        }
        this.arrayType = type;
        this.baseType = null;
        this.classType = null;
    }

    public <R, P> R accept(ASTNodeVisitor<R, P> visitor, P arg) {
        return visitor.visit(this, arg);
    }

    public String toString() {
        if (this.baseType != null) {
            return this.baseType.toString();
        }
        if (this.classType != null) {
            return this.classType.toString();
        }
        if (this.arrayType != null) {
            return this.arrayType.toString();
        }
        throw new ASTStructureException("At least one of the fields must be non-null");
    }
}

